/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.rewrite.sql.token.common.pojo.generic;

import com.cedarsoftware.util.CaseInsensitiveMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.Projection;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.impl.ColumnProjection;
import org.apache.shardingsphere.infra.database.core.metadata.database.enums.QuoteCharacter;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.database.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.pojo.RouteUnitAware;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.pojo.SQLToken;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.pojo.Substitutable;
import org.apache.shardingsphere.infra.route.context.RouteMapper;
import org.apache.shardingsphere.infra.route.context.RouteUnit;
import org.apache.shardingsphere.sql.parser.statement.core.value.identifier.IdentifierValue;

public final class SubstitutableColumnNameToken
extends SQLToken
implements Substitutable,
RouteUnitAware {
    private static final String COLUMN_NAME_SPLITTER = ", ";
    private final int stopIndex;
    private final Collection<Projection> projections;
    private final QuoteCharacter quoteCharacter;

    public SubstitutableColumnNameToken(int startIndex, int stopIndex, Collection<Projection> projections, DatabaseType databaseType) {
        super(startIndex);
        this.stopIndex = stopIndex;
        this.quoteCharacter = new DatabaseTypeRegistry(databaseType).getDialectDatabaseMetaData().getQuoteCharacter();
        this.projections = projections;
    }

    @Override
    public String toString(RouteUnit routeUnit) {
        Map<String, String> logicAndActualTables = this.getLogicAndActualTables(routeUnit);
        StringBuilder result = new StringBuilder();
        int index = 0;
        for (Projection each : this.projections) {
            if (index > 0) {
                result.append(COLUMN_NAME_SPLITTER);
            }
            result.append(this.getColumnExpression(each, logicAndActualTables));
            ++index;
        }
        return result.toString();
    }

    private Map<String, String> getLogicAndActualTables(RouteUnit routeUnit) {
        if (null == routeUnit) {
            return Collections.emptyMap();
        }
        CaseInsensitiveMap result = new CaseInsensitiveMap();
        for (RouteMapper each : routeUnit.getTableMappers()) {
            result.put(each.getLogicName().toLowerCase(), each.getActualName());
        }
        return result;
    }

    private String getColumnExpression(Projection projection, Map<String, String> logicActualTableNames) {
        StringBuilder builder = new StringBuilder();
        if (projection instanceof ColumnProjection) {
            this.appendColumnProjection((ColumnProjection)projection, logicActualTableNames, builder);
        } else {
            builder.append(this.quoteCharacter.wrap(projection.getColumnLabel()));
        }
        return builder.toString();
    }

    private void appendColumnProjection(ColumnProjection columnProjection, Map<String, String> logicActualTableNames, StringBuilder builder) {
        columnProjection.getLeftParentheses().ifPresent(optional -> builder.append("("));
        if (columnProjection.getOwner().isPresent()) {
            IdentifierValue owner = (IdentifierValue)columnProjection.getOwner().get();
            String actualTableOwner = logicActualTableNames.getOrDefault(owner.getValue(), owner.getValue());
            builder.append(this.getValueWithQuoteCharacters(new IdentifierValue(actualTableOwner, owner.getQuoteCharacter()))).append('.');
        }
        builder.append(this.getValueWithQuoteCharacters(columnProjection.getName()));
        columnProjection.getRightParentheses().ifPresent(optional -> builder.append(")"));
        if (columnProjection.getAlias().isPresent()) {
            builder.append(" AS ").append(this.getValueWithQuoteCharacters((IdentifierValue)columnProjection.getAlias().get()));
        }
    }

    private String getValueWithQuoteCharacters(IdentifierValue identifierValue) {
        return QuoteCharacter.NONE == identifierValue.getQuoteCharacter() ? identifierValue.getValue() : this.quoteCharacter.wrap(identifierValue.getValue());
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SubstitutableColumnNameToken)) {
            return false;
        }
        SubstitutableColumnNameToken other = (SubstitutableColumnNameToken)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getStopIndex() != other.getStopIndex()) {
            return false;
        }
        Collection<Projection> this$projections = this.projections;
        Collection<Projection> other$projections = other.projections;
        if (this$projections == null ? other$projections != null : !((Object)this$projections).equals(other$projections)) {
            return false;
        }
        QuoteCharacter this$quoteCharacter = this.quoteCharacter;
        QuoteCharacter other$quoteCharacter = other.quoteCharacter;
        return !(this$quoteCharacter == null ? other$quoteCharacter != null : !this$quoteCharacter.equals(other$quoteCharacter));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SubstitutableColumnNameToken;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getStopIndex();
        Collection<Projection> $projections = this.projections;
        result = result * 59 + ($projections == null ? 43 : ((Object)$projections).hashCode());
        QuoteCharacter $quoteCharacter = this.quoteCharacter;
        result = result * 59 + ($quoteCharacter == null ? 43 : $quoteCharacter.hashCode());
        return result;
    }

    @Override
    @Generated
    public int getStopIndex() {
        return this.stopIndex;
    }
}

