/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.handler.distsql.ral.updatable;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import org.apache.shardingsphere.distsql.handler.engine.update.DistSQLUpdateExecutor;
import org.apache.shardingsphere.distsql.statement.ral.updatable.SetDistVariableStatement;
import org.apache.shardingsphere.infra.config.props.ConfigurationPropertyKey;
import org.apache.shardingsphere.infra.config.props.temporary.TemporaryConfigurationPropertyKey;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.kernel.syntax.InvalidVariableValueException;
import org.apache.shardingsphere.infra.exception.kernel.syntax.UnsupportedVariableException;
import org.apache.shardingsphere.infra.props.TypedPropertyKey;
import org.apache.shardingsphere.infra.props.TypedPropertyValue;
import org.apache.shardingsphere.infra.props.exception.TypedPropertyValueException;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPI;
import org.apache.shardingsphere.logging.rule.LoggingRule;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.mode.metadata.MetaDataContexts;
import org.apache.shardingsphere.mode.metadata.decorator.RuleConfigurationPersistDecorateEngine;
import org.slf4j.LoggerFactory;

public final class SetDistVariableExecutor
implements DistSQLUpdateExecutor<SetDistVariableStatement> {
    public void executeUpdate(SetDistVariableStatement sqlStatement, ContextManager contextManager) throws SQLException {
        ShardingSpherePreconditions.checkState((boolean)(this.getEnumType(sqlStatement.getName()) instanceof TypedPropertyKey), () -> new UnsupportedVariableException(sqlStatement.getName()));
        this.handleConfigurationProperty(contextManager, (TypedPropertyKey)this.getEnumType(sqlStatement.getName()), sqlStatement.getValue());
    }

    private Enum<?> getEnumType(String name) {
        try {
            return ConfigurationPropertyKey.valueOf((String)name.toUpperCase());
        }
        catch (IllegalArgumentException ex) {
            try {
                return TemporaryConfigurationPropertyKey.valueOf((String)name.toUpperCase());
            }
            catch (IllegalArgumentException exception) {
                throw new UnsupportedVariableException(name);
            }
        }
    }

    private void handleConfigurationProperty(ContextManager contextManager, TypedPropertyKey propertyKey, String value) throws SQLException {
        MetaDataContexts metaDataContexts = contextManager.getMetaDataContexts();
        Properties props = new Properties();
        props.putAll((Map<?, ?>)metaDataContexts.getMetaData().getProps().getProps());
        props.putAll((Map<?, ?>)metaDataContexts.getMetaData().getTemporaryProps().getProps());
        props.put(propertyKey.getKey(), this.getValue(propertyKey, value));
        contextManager.getPersistServiceFacade().getMetaDataManagerPersistService().alterProperties(props);
        this.refreshRootLogger(props);
        this.syncSQLShowToLoggingRule(propertyKey, metaDataContexts, value, contextManager);
        this.syncSQLSimpleToLoggingRule(propertyKey, metaDataContexts, value, contextManager);
    }

    private Object getValue(TypedPropertyKey propertyKey, String value) {
        try {
            Object propertyValue = new TypedPropertyValue(propertyKey, value).getValue();
            if (Enum.class.isAssignableFrom(propertyKey.getType())) {
                return propertyValue.toString();
            }
            return TypedSPI.class.isAssignableFrom(propertyKey.getType()) ? ((TypedSPI)propertyValue).getType().toString() : propertyValue;
        }
        catch (TypedPropertyValueException ignored) {
            throw new InvalidVariableValueException(value);
        }
    }

    private void refreshRootLogger(Properties props) {
        LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
        Logger rootLogger = loggerContext.getLogger("ROOT");
        this.renewRootLoggerLevel(rootLogger, props);
    }

    private void renewRootLoggerLevel(Logger rootLogger, Properties props) {
        rootLogger.setLevel(Level.valueOf((String)props.getOrDefault((Object)ConfigurationPropertyKey.SYSTEM_LOG_LEVEL.getKey(), ConfigurationPropertyKey.SYSTEM_LOG_LEVEL.getDefaultValue()).toString()));
    }

    private void syncSQLShowToLoggingRule(TypedPropertyKey propertyKey, MetaDataContexts metaDataContexts, String value, ContextManager contextManager) {
        if ("sql-show".equalsIgnoreCase(propertyKey.getKey())) {
            metaDataContexts.getMetaData().getGlobalRuleMetaData().findSingleRule(LoggingRule.class).flatMap(LoggingRule::getSQLLogger).ifPresent(option -> {
                option.getProps().setProperty("enable", value);
                this.decorateGlobalRuleConfiguration(contextManager);
            });
        }
    }

    private void syncSQLSimpleToLoggingRule(TypedPropertyKey propertyKey, MetaDataContexts metaDataContexts, String value, ContextManager contextManager) {
        if ("sql-simple".equalsIgnoreCase(propertyKey.getKey())) {
            metaDataContexts.getMetaData().getGlobalRuleMetaData().findSingleRule(LoggingRule.class).flatMap(LoggingRule::getSQLLogger).ifPresent(optional -> {
                optional.getProps().setProperty("simple", value);
                this.decorateGlobalRuleConfiguration(contextManager);
            });
        }
    }

    private void decorateGlobalRuleConfiguration(ContextManager contextManager) {
        RuleConfigurationPersistDecorateEngine ruleConfigPersistDecorateEngine = new RuleConfigurationPersistDecorateEngine(contextManager.getComputeNodeInstanceContext());
        Collection globalRuleConfigs = ruleConfigPersistDecorateEngine.decorate(contextManager.getMetaDataContexts().getMetaData().getGlobalRuleMetaData().getConfigurations());
        contextManager.getPersistServiceFacade().getMetaDataPersistService().getGlobalRuleService().persist(globalRuleConfigs);
    }

    public Class<SetDistVariableStatement> getType() {
        return SetDistVariableStatement.class;
    }
}

