/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.util;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.rule.RuleConfiguration;
import org.apache.shardingsphere.infra.config.rule.scope.DatabaseRuleConfiguration;
import org.apache.shardingsphere.infra.datasource.pool.props.domain.DataSourcePoolProperties;
import org.apache.shardingsphere.infra.exception.generic.FileIOException;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.resource.unit.StorageUnit;
import org.apache.shardingsphere.infra.spi.type.ordered.OrderedSPILoader;
import org.apache.shardingsphere.infra.util.yaml.YamlEngine;
import org.apache.shardingsphere.infra.yaml.config.swapper.rule.YamlRuleConfigurationSwapper;

public final class ExportUtils {
    public static void exportToFile(String filePath, String exportedData) {
        File file = new File(filePath);
        if (!file.exists() && null != file.getParentFile()) {
            file.getParentFile().mkdirs();
        }
        try (OutputStream output = Files.newOutputStream(Paths.get(file.toURI()), new OpenOption[0]);){
            output.write(exportedData.getBytes());
            output.flush();
        }
        catch (IOException ignore) {
            throw new FileIOException(file);
        }
    }

    public static String generateExportDatabaseData(ShardingSphereDatabase database) {
        StringBuilder result = new StringBuilder();
        ExportUtils.appendDatabaseName(database.getName(), result);
        ExportUtils.appendDataSourceConfigurations(database, result);
        ExportUtils.appendRuleConfigurations(database.getRuleMetaData().getConfigurations(), result);
        return result.toString();
    }

    private static void appendDatabaseName(String databaseName, StringBuilder stringBuilder) {
        stringBuilder.append("databaseName: ").append(databaseName).append(System.lineSeparator());
    }

    private static void appendDataSourceConfigurations(ShardingSphereDatabase database, StringBuilder stringBuilder) {
        if (database.getResourceMetaData().getStorageUnits().isEmpty()) {
            return;
        }
        stringBuilder.append("dataSources:").append(System.lineSeparator());
        for (Map.Entry entry : database.getResourceMetaData().getStorageUnits().entrySet()) {
            ExportUtils.appendDataSourceConfiguration((String)entry.getKey(), ((StorageUnit)entry.getValue()).getDataSourcePoolProperties(), stringBuilder);
        }
    }

    private static void appendDataSourceConfiguration(String name, DataSourcePoolProperties props, StringBuilder stringBuilder) {
        stringBuilder.append("  ").append(name).append(':').append(System.lineSeparator());
        props.getConnectionPropertySynonyms().getStandardProperties().forEach((key, value) -> stringBuilder.append("    ").append((String)key).append(": ").append(value).append(System.lineSeparator()));
        for (Map.Entry entry : props.getPoolPropertySynonyms().getStandardProperties().entrySet()) {
            if (null == entry.getValue()) continue;
            stringBuilder.append("    ").append((String)entry.getKey()).append(": ").append(entry.getValue()).append(System.lineSeparator());
        }
    }

    private static void appendRuleConfigurations(Collection<RuleConfiguration> ruleConfigs, StringBuilder stringBuilder) {
        if (ruleConfigs.isEmpty() || ruleConfigs.stream().allMatch(each -> ((DatabaseRuleConfiguration)each).isEmpty())) {
            return;
        }
        stringBuilder.append("rules:").append(System.lineSeparator());
        for (Map.Entry entry : OrderedSPILoader.getServices(YamlRuleConfigurationSwapper.class, ruleConfigs).entrySet()) {
            if (((DatabaseRuleConfiguration)entry.getKey()).isEmpty()) continue;
            stringBuilder.append(YamlEngine.marshal(Collections.singletonList(((YamlRuleConfigurationSwapper)entry.getValue()).swapToYamlConfiguration(entry.getKey()))));
        }
    }

    @Generated
    private ExportUtils() {
    }
}

