/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.distsql.handler.engine.update.rdl.rule.engine.database.type;

import java.sql.SQLException;
import java.util.Objects;
import lombok.Generated;
import org.apache.shardingsphere.distsql.handler.engine.update.rdl.rule.engine.database.DatabaseRuleOperator;
import org.apache.shardingsphere.distsql.handler.engine.update.rdl.rule.spi.database.DatabaseRuleDropExecutor;
import org.apache.shardingsphere.distsql.statement.rdl.rule.aware.StaticDataSourceContainedRuleAwareStatement;
import org.apache.shardingsphere.distsql.statement.rdl.rule.database.DatabaseRuleDefinitionStatement;
import org.apache.shardingsphere.infra.config.rule.RuleConfiguration;
import org.apache.shardingsphere.infra.config.rule.scope.DatabaseRuleConfiguration;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.rule.attribute.datasource.StaticDataSourceRuleAttribute;
import org.apache.shardingsphere.infra.yaml.config.pojo.rule.YamlRuleConfiguration;
import org.apache.shardingsphere.infra.yaml.config.swapper.rule.YamlRuleConfigurationSwapperEngine;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.mode.persist.service.MetaDataManagerPersistService;
import org.apache.shardingsphere.mode.tuple.annotation.RepositoryTupleEntity;

public final class DropDatabaseRuleOperator
implements DatabaseRuleOperator {
    private final ContextManager contextManager;
    private final DatabaseRuleDropExecutor executor;

    @Override
    public void operate(DatabaseRuleDefinitionStatement sqlStatement, ShardingSphereDatabase database, RuleConfiguration currentRuleConfig) throws SQLException {
        if (!this.executor.hasAnyOneToBeDropped(sqlStatement)) {
            return;
        }
        if (sqlStatement instanceof StaticDataSourceContainedRuleAwareStatement) {
            for (StaticDataSourceRuleAttribute each : database.getRuleMetaData().getAttributes(StaticDataSourceRuleAttribute.class)) {
                ((StaticDataSourceContainedRuleAwareStatement)sqlStatement).getNames().forEach(arg_0 -> ((StaticDataSourceRuleAttribute)each).cleanStorageNodeDataSource(arg_0));
            }
        }
        MetaDataManagerPersistService metaDataManagerPersistService = this.contextManager.getPersistServiceFacade().getMetaDataManagerPersistService();
        Object toBeDroppedRuleConfig = this.executor.buildToBeDroppedRuleConfiguration(sqlStatement);
        metaDataManagerPersistService.removeRuleConfigurationItem(database.getName(), toBeDroppedRuleConfig);
        Object toBeAlteredRuleConfig = this.executor.buildToBeAlteredRuleConfiguration(sqlStatement);
        if (null != toBeAlteredRuleConfig && ((DatabaseRuleConfiguration)toBeAlteredRuleConfig).isEmpty()) {
            YamlRuleConfiguration yamlRuleConfig = new YamlRuleConfigurationSwapperEngine().swapToYamlRuleConfiguration(currentRuleConfig);
            metaDataManagerPersistService.removeRuleConfiguration(database.getName(), Objects.requireNonNull(yamlRuleConfig.getClass().getAnnotation(RepositoryTupleEntity.class)).value());
        } else {
            metaDataManagerPersistService.alterRuleConfiguration(database.getName(), toBeAlteredRuleConfig);
        }
    }

    @Generated
    public DropDatabaseRuleOperator(ContextManager contextManager, DatabaseRuleDropExecutor executor) {
        this.contextManager = contextManager;
        this.executor = executor;
    }
}

