/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.mysql.ingest.incremental.binlog.position;

import com.google.common.base.Preconditions;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.shardingsphere.data.pipeline.core.ingest.position.DialectIncrementalPositionManager;
import org.apache.shardingsphere.data.pipeline.mysql.ingest.incremental.binlog.position.MySQLBinlogPosition;

public final class MySQLIncrementalPositionManager
implements DialectIncrementalPositionManager {
    public MySQLBinlogPosition init(String data) {
        String[] array = data.split("#");
        Preconditions.checkArgument((2 == array.length ? 1 : 0) != 0, (String)"Unknown binlog position: %s", (Object)data);
        return new MySQLBinlogPosition(array[0], Long.parseLong(array[1]));
    }

    public MySQLBinlogPosition init(DataSource dataSource, String slotNameSuffix) throws SQLException {
        try (Connection connection = dataSource.getConnection();){
            MySQLBinlogPosition mySQLBinlogPosition = this.getBinlogPosition(connection);
            return mySQLBinlogPosition;
        }
    }

    private MySQLBinlogPosition getBinlogPosition(Connection connection) throws SQLException {
        try (PreparedStatement preparedStatement = connection.prepareStatement("SHOW MASTER STATUS");){
            MySQLBinlogPosition mySQLBinlogPosition;
            block12: {
                ResultSet resultSet = preparedStatement.executeQuery();
                try {
                    resultSet.next();
                    mySQLBinlogPosition = new MySQLBinlogPosition(resultSet.getString(1), resultSet.getLong(2));
                    if (resultSet == null) break block12;
                }
                catch (Throwable throwable) {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                resultSet.close();
            }
            return mySQLBinlogPosition;
        }
    }

    public String getDatabaseType() {
        return "MySQL";
    }
}

