/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.mysql.handler.admin.executor;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.infra.database.core.metadata.database.system.SystemDatabase;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.QueryResult;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.QueryResultMetaData;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.impl.raw.metadata.RawQueryResultColumnMetaData;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.impl.raw.metadata.RawQueryResultMetaData;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.impl.raw.type.RawMemoryQueryResult;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.type.memory.row.MemoryQueryResultDataRow;
import org.apache.shardingsphere.infra.merge.result.MergedResult;
import org.apache.shardingsphere.infra.merge.result.impl.transparent.TransparentMergedResult;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereTable;
import org.apache.shardingsphere.infra.util.regex.RegexUtils;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.handler.admin.executor.DatabaseAdminQueryExecutor;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dal.ShowFilterSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.dal.ShowTablesStatement;

public final class ShowTablesExecutor
implements DatabaseAdminQueryExecutor {
    private final ShowTablesStatement sqlStatement;
    private final DatabaseType databaseType;
    private QueryResultMetaData queryResultMetaData;
    private MergedResult mergedResult;

    public void execute(ConnectionSession connectionSession) {
        String databaseName = this.sqlStatement.getFromDatabase().map(schema -> schema.getDatabase().getIdentifier().getValue()).orElseGet(() -> ((ConnectionSession)connectionSession).getUsedDatabaseName());
        this.queryResultMetaData = this.createQueryResultMetaData(databaseName);
        this.mergedResult = new TransparentMergedResult(this.getQueryResult(databaseName));
    }

    private QueryResultMetaData createQueryResultMetaData(String databaseName) {
        LinkedList<RawQueryResultColumnMetaData> columnNames = new LinkedList<RawQueryResultColumnMetaData>();
        String tableColumnName = String.format("Tables_in_%s", databaseName);
        columnNames.add(new RawQueryResultColumnMetaData("", tableColumnName, tableColumnName, 12, "VARCHAR", 255, 0));
        if (this.sqlStatement.isContainsFull()) {
            columnNames.add(new RawQueryResultColumnMetaData("", "Table_type", "Table_type", 12, "VARCHAR", 20, 0));
        }
        return new RawQueryResultMetaData(columnNames);
    }

    private QueryResult getQueryResult(String databaseName) {
        SystemDatabase systemDatabase = new SystemDatabase(this.databaseType);
        if (!systemDatabase.getSystemSchemas().contains(databaseName) && !ProxyContext.getInstance().getContextManager().getDatabase(databaseName).isComplete()) {
            return new RawMemoryQueryResult(this.queryResultMetaData, Collections.emptyList());
        }
        List rows = this.getTables(databaseName).stream().map(this::getRow).collect(Collectors.toList());
        return new RawMemoryQueryResult(this.queryResultMetaData, rows);
    }

    private MemoryQueryResultDataRow getRow(ShardingSphereTable table) {
        return this.sqlStatement.isContainsFull() ? new MemoryQueryResultDataRow(Arrays.asList(table.getName(), table.getType())) : new MemoryQueryResultDataRow(Collections.singletonList(table.getName()));
    }

    private Collection<ShardingSphereTable> getTables(String databaseName) {
        Collection<ShardingSphereTable> tables = ProxyContext.getInstance().getContextManager().getDatabase(databaseName).getSchema(databaseName).getTables().values();
        Collection<ShardingSphereTable> filteredTables = this.filterByLike(tables);
        return filteredTables.stream().sorted(Comparator.comparing(ShardingSphereTable::getName)).collect(Collectors.toList());
    }

    private Collection<ShardingSphereTable> filterByLike(Collection<ShardingSphereTable> tables) {
        Optional<Pattern> likePattern = this.getLikePattern();
        return likePattern.isPresent() ? (Collection)tables.stream().filter(each -> ((Pattern)likePattern.get()).matcher(each.getName()).matches()).collect(Collectors.toList()) : tables;
    }

    private Optional<Pattern> getLikePattern() {
        if (!this.sqlStatement.getFilter().isPresent()) {
            return Optional.empty();
        }
        Optional<String> regex = ((ShowFilterSegment)this.sqlStatement.getFilter().get()).getLike().map(optional -> RegexUtils.convertLikePatternToRegex((String)optional.getPattern()));
        return regex.map(optional -> Pattern.compile(optional, 2));
    }

    @Generated
    public ShowTablesExecutor(ShowTablesStatement sqlStatement, DatabaseType databaseType) {
        this.sqlStatement = sqlStatement;
        this.databaseType = databaseType;
    }

    @Generated
    public QueryResultMetaData getQueryResultMetaData() {
        return this.queryResultMetaData;
    }

    @Generated
    public MergedResult getMergedResult() {
        return this.mergedResult;
    }
}

