/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shadow.rule.changed;

import org.apache.shardingsphere.infra.algorithm.core.config.AlgorithmConfiguration;
import org.apache.shardingsphere.infra.algorithm.core.yaml.YamlAlgorithmConfiguration;
import org.apache.shardingsphere.infra.algorithm.core.yaml.YamlAlgorithmConfigurationSwapper;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.util.yaml.YamlEngine;
import org.apache.shardingsphere.mode.event.dispatch.rule.alter.AlterNamedRuleItemEvent;
import org.apache.shardingsphere.mode.event.dispatch.rule.alter.AlterRuleItemEvent;
import org.apache.shardingsphere.mode.event.dispatch.rule.drop.DropNamedRuleItemEvent;
import org.apache.shardingsphere.mode.event.dispatch.rule.drop.DropRuleItemEvent;
import org.apache.shardingsphere.mode.spi.RuleItemConfigurationChangedProcessor;
import org.apache.shardingsphere.shadow.config.ShadowRuleConfiguration;
import org.apache.shardingsphere.shadow.rule.ShadowRule;

public final class ShadowAlgorithmChangedProcessor
implements RuleItemConfigurationChangedProcessor<ShadowRuleConfiguration, AlgorithmConfiguration> {
    public AlgorithmConfiguration swapRuleItemConfiguration(AlterRuleItemEvent event, String yamlContent) {
        return new YamlAlgorithmConfigurationSwapper().swapToObject((YamlAlgorithmConfiguration)YamlEngine.unmarshal((String)yamlContent, YamlAlgorithmConfiguration.class));
    }

    public ShadowRuleConfiguration findRuleConfiguration(ShardingSphereDatabase database) {
        return database.getRuleMetaData().findSingleRule(ShadowRule.class).map(ShadowRule::getConfiguration).orElseGet(ShadowRuleConfiguration::new);
    }

    public void changeRuleItemConfiguration(AlterRuleItemEvent event, ShadowRuleConfiguration currentRuleConfig, AlgorithmConfiguration toBeChangedItemConfig) {
        currentRuleConfig.getShadowAlgorithms().put(((AlterNamedRuleItemEvent)event).getItemName(), toBeChangedItemConfig);
    }

    public void dropRuleItemConfiguration(DropRuleItemEvent event, ShadowRuleConfiguration currentRuleConfig) {
        currentRuleConfig.getShadowAlgorithms().remove(((DropNamedRuleItemEvent)event).getItemName());
    }

    public String getType() {
        return "shadow.shadow_algorithms";
    }
}

