/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.metadata.manager;

import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.infra.datasource.pool.destroyer.DataSourcePoolDestroyer;
import org.apache.shardingsphere.infra.datasource.pool.props.domain.DataSourcePoolProperties;
import org.apache.shardingsphere.infra.metadata.database.resource.node.StorageNode;

public final class SwitchingResource {
    private final Map<StorageNode, DataSource> newDataSources;
    private final Map<StorageNode, DataSource> staleDataSources;
    private final Collection<String> staleStorageUnitNames;
    private final Map<String, DataSourcePoolProperties> mergedDataSourcePoolPropertiesMap;

    public void closeStaleDataSources() {
        this.staleDataSources.values().stream().filter(Objects::nonNull).forEach(each -> new DataSourcePoolDestroyer(each).asyncDestroy());
    }

    @Generated
    public SwitchingResource(Map<StorageNode, DataSource> newDataSources, Map<StorageNode, DataSource> staleDataSources, Collection<String> staleStorageUnitNames, Map<String, DataSourcePoolProperties> mergedDataSourcePoolPropertiesMap) {
        this.newDataSources = newDataSources;
        this.staleDataSources = staleDataSources;
        this.staleStorageUnitNames = staleStorageUnitNames;
        this.mergedDataSourcePoolPropertiesMap = mergedDataSourcePoolPropertiesMap;
    }

    @Generated
    public Map<StorageNode, DataSource> getNewDataSources() {
        return this.newDataSources;
    }

    @Generated
    public Map<StorageNode, DataSource> getStaleDataSources() {
        return this.staleDataSources;
    }

    @Generated
    public Collection<String> getStaleStorageUnitNames() {
        return this.staleStorageUnitNames;
    }

    @Generated
    public Map<String, DataSourcePoolProperties> getMergedDataSourcePoolPropertiesMap() {
        return this.mergedDataSourcePoolPropertiesMap;
    }
}

