/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.sqlserver.visitor.statement.type;

import java.util.Collections;
import java.util.LinkedList;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.shardingsphere.sql.parser.api.ASTNode;
import org.apache.shardingsphere.sql.parser.api.visitor.statement.type.DDLStatementVisitor;
import org.apache.shardingsphere.sql.parser.autogen.SQLServerStatementParser;
import org.apache.shardingsphere.sql.parser.sqlserver.visitor.statement.SQLServerStatementVisitor;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.AlterDefinitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.CreateDefinitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.column.ColumnDefinitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.column.alter.AddColumnDefinitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.column.alter.DropColumnDefinitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.column.alter.ModifyColumnDefinitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.constraint.ConstraintDefinitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.constraint.ConstraintSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.constraint.alter.AddConstraintDefinitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.constraint.alter.DropConstraintDefinitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.constraint.alter.ModifyConstraintDefinitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.index.IndexSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.DataTypeSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.dml.SelectStatement;
import org.apache.shardingsphere.sql.parser.statement.core.value.collection.CollectionValue;
import org.apache.shardingsphere.sql.parser.statement.sqlserver.ddl.SQLServerAlterDatabaseStatement;
import org.apache.shardingsphere.sql.parser.statement.sqlserver.ddl.SQLServerAlterFunctionStatement;
import org.apache.shardingsphere.sql.parser.statement.sqlserver.ddl.SQLServerAlterIndexStatement;
import org.apache.shardingsphere.sql.parser.statement.sqlserver.ddl.SQLServerAlterProcedureStatement;
import org.apache.shardingsphere.sql.parser.statement.sqlserver.ddl.SQLServerAlterSchemaStatement;
import org.apache.shardingsphere.sql.parser.statement.sqlserver.ddl.SQLServerAlterSequenceStatement;
import org.apache.shardingsphere.sql.parser.statement.sqlserver.ddl.SQLServerAlterServiceStatement;
import org.apache.shardingsphere.sql.parser.statement.sqlserver.ddl.SQLServerAlterTableStatement;
import org.apache.shardingsphere.sql.parser.statement.sqlserver.ddl.SQLServerAlterTriggerStatement;
import org.apache.shardingsphere.sql.parser.statement.sqlserver.ddl.SQLServerAlterViewStatement;
import org.apache.shardingsphere.sql.parser.statement.sqlserver.ddl.SQLServerCreateDatabaseStatement;
import org.apache.shardingsphere.sql.parser.statement.sqlserver.ddl.SQLServerCreateFunctionStatement;
import org.apache.shardingsphere.sql.parser.statement.sqlserver.ddl.SQLServerCreateIndexStatement;
import org.apache.shardingsphere.sql.parser.statement.sqlserver.ddl.SQLServerCreateProcedureStatement;
import org.apache.shardingsphere.sql.parser.statement.sqlserver.ddl.SQLServerCreateSchemaStatement;
import org.apache.shardingsphere.sql.parser.statement.sqlserver.ddl.SQLServerCreateSequenceStatement;
import org.apache.shardingsphere.sql.parser.statement.sqlserver.ddl.SQLServerCreateServiceStatement;
import org.apache.shardingsphere.sql.parser.statement.sqlserver.ddl.SQLServerCreateTableStatement;
import org.apache.shardingsphere.sql.parser.statement.sqlserver.ddl.SQLServerCreateTriggerStatement;
import org.apache.shardingsphere.sql.parser.statement.sqlserver.ddl.SQLServerCreateViewStatement;
import org.apache.shardingsphere.sql.parser.statement.sqlserver.ddl.SQLServerDropDatabaseStatement;
import org.apache.shardingsphere.sql.parser.statement.sqlserver.ddl.SQLServerDropFunctionStatement;
import org.apache.shardingsphere.sql.parser.statement.sqlserver.ddl.SQLServerDropIndexStatement;
import org.apache.shardingsphere.sql.parser.statement.sqlserver.ddl.SQLServerDropProcedureStatement;
import org.apache.shardingsphere.sql.parser.statement.sqlserver.ddl.SQLServerDropSchemaStatement;
import org.apache.shardingsphere.sql.parser.statement.sqlserver.ddl.SQLServerDropSequenceStatement;
import org.apache.shardingsphere.sql.parser.statement.sqlserver.ddl.SQLServerDropServiceStatement;
import org.apache.shardingsphere.sql.parser.statement.sqlserver.ddl.SQLServerDropTableStatement;
import org.apache.shardingsphere.sql.parser.statement.sqlserver.ddl.SQLServerDropTriggerStatement;
import org.apache.shardingsphere.sql.parser.statement.sqlserver.ddl.SQLServerDropViewStatement;
import org.apache.shardingsphere.sql.parser.statement.sqlserver.ddl.SQLServerTruncateStatement;
import org.apache.shardingsphere.sql.parser.statement.sqlserver.dml.SQLServerSelectStatement;

public final class SQLServerDDLStatementVisitor
extends SQLServerStatementVisitor
implements DDLStatementVisitor {
    @Override
    public ASTNode visitCreateTable(SQLServerStatementParser.CreateTableContext ctx) {
        return null == ctx.createTableClause() ? (ASTNode)this.visit((ParseTree)ctx.createTableAsSelectClause()) : (ASTNode)this.visit((ParseTree)ctx.createTableClause());
    }

    @Override
    public ASTNode visitCreateTableClause(SQLServerStatementParser.CreateTableClauseContext ctx) {
        SQLServerCreateTableStatement result = new SQLServerCreateTableStatement();
        result.setTable((SimpleTableSegment)this.visit((ParseTree)ctx.tableName()));
        CollectionValue createDefinitions = (CollectionValue)this.generateCreateDefinitionSegment(ctx.createDefinitionClause().createTableDefinitions());
        for (CreateDefinitionSegment each : createDefinitions.getValue()) {
            if (each instanceof ColumnDefinitionSegment) {
                result.getColumnDefinitions().add((ColumnDefinitionSegment)each);
                continue;
            }
            if (!(each instanceof ConstraintDefinitionSegment)) continue;
            result.getConstraintDefinitions().add((ConstraintDefinitionSegment)each);
        }
        return result;
    }

    private ASTNode generateCreateDefinitionSegment(SQLServerStatementParser.CreateTableDefinitionsContext ctx) {
        CollectionValue result = new CollectionValue();
        for (SQLServerStatementParser.CreateTableDefinitionContext each : ctx.createTableDefinition()) {
            if (null != each.columnDefinition()) {
                result.getValue().add((ColumnDefinitionSegment)this.visit((ParseTree)each.columnDefinition()));
            }
            if (null == each.tableConstraint()) continue;
            result.getValue().add((ConstraintDefinitionSegment)this.visit((ParseTree)each.tableConstraint()));
        }
        return result;
    }

    @Override
    public ASTNode visitColumnDefinition(SQLServerStatementParser.ColumnDefinitionContext ctx) {
        ColumnSegment column = (ColumnSegment)this.visit((ParseTree)ctx.columnName());
        DataTypeSegment dataType = (DataTypeSegment)this.visit((ParseTree)ctx.dataType());
        boolean isPrimaryKey = this.isPrimaryKey(ctx);
        ColumnDefinitionSegment result = new ColumnDefinitionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), column, dataType, isPrimaryKey, false);
        for (SQLServerStatementParser.ColumnDefinitionOptionContext columnDefinitionOptionContext : ctx.columnDefinitionOption()) {
            for (SQLServerStatementParser.ColumnConstraintContext columnConstraint : columnDefinitionOptionContext.columnConstraint()) {
                if (null == columnConstraint.columnForeignKeyConstraint()) continue;
                result.getReferencedTables().add((SimpleTableSegment)this.visit((ParseTree)columnConstraint.columnForeignKeyConstraint().tableName()));
            }
        }
        for (SQLServerStatementParser.ColumnConstraintContext columnConstraintContext : ctx.columnConstraints().columnConstraint()) {
            if (null == columnConstraintContext.columnForeignKeyConstraint()) continue;
            result.getReferencedTables().add((SimpleTableSegment)this.visit((ParseTree)columnConstraintContext.columnForeignKeyConstraint().tableName()));
        }
        return result;
    }

    private boolean isPrimaryKey(SQLServerStatementParser.ColumnDefinitionContext ctx) {
        for (SQLServerStatementParser.ColumnDefinitionOptionContext columnDefinitionOptionContext : ctx.columnDefinitionOption()) {
            for (SQLServerStatementParser.ColumnConstraintContext columnConstraint : columnDefinitionOptionContext.columnConstraint()) {
                if (null == columnConstraint.primaryKeyConstraint() || null == columnConstraint.primaryKeyConstraint().primaryKey()) continue;
                return true;
            }
        }
        for (SQLServerStatementParser.ColumnConstraintContext columnConstraintContext : ctx.columnConstraints().columnConstraint()) {
            if (null == columnConstraintContext.primaryKeyConstraint() || null == columnConstraintContext.primaryKeyConstraint().primaryKey()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ASTNode visitTableConstraint(SQLServerStatementParser.TableConstraintContext ctx) {
        ConstraintDefinitionSegment result = new ConstraintDefinitionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex());
        if (null != ctx.constraintName()) {
            result.setConstraintName((ConstraintSegment)this.visit((ParseTree)ctx.constraintName()));
        }
        if (null != ctx.tablePrimaryConstraint() && null != ctx.tablePrimaryConstraint().primaryKeyUnique().primaryKey()) {
            if (null != ctx.tablePrimaryConstraint().diskTablePrimaryConstraintOption()) {
                result.getPrimaryKeyColumns().addAll(((CollectionValue)this.visit((ParseTree)ctx.tablePrimaryConstraint().diskTablePrimaryConstraintOption().columnNames())).getValue());
            }
            if (null != ctx.tablePrimaryConstraint().memoryTablePrimaryConstraintOption()) {
                result.getPrimaryKeyColumns().addAll(((CollectionValue)this.visit((ParseTree)ctx.tablePrimaryConstraint().memoryTablePrimaryConstraintOption().columnNames())).getValue());
            }
        }
        if (null != ctx.tableForeignKeyConstraint()) {
            result.setReferencedTable((SimpleTableSegment)this.visit((ParseTree)ctx.tableForeignKeyConstraint().tableName()));
        }
        return result;
    }

    @Override
    public ASTNode visitAlterTable(SQLServerStatementParser.AlterTableContext ctx) {
        SQLServerAlterTableStatement result = new SQLServerAlterTableStatement();
        result.setTable((SimpleTableSegment)this.visit((ParseTree)ctx.tableName()));
        for (SQLServerStatementParser.AlterDefinitionClauseContext alterDefinitionClauseContext : ctx.alterDefinitionClause()) {
            for (AlterDefinitionSegment each : ((CollectionValue)this.visit((ParseTree)alterDefinitionClauseContext)).getValue()) {
                if (each instanceof AddColumnDefinitionSegment) {
                    result.getAddColumnDefinitions().add((AddColumnDefinitionSegment)each);
                    continue;
                }
                if (each instanceof ModifyColumnDefinitionSegment) {
                    result.getModifyColumnDefinitions().add((ModifyColumnDefinitionSegment)each);
                    continue;
                }
                if (each instanceof DropColumnDefinitionSegment) {
                    result.getDropColumnDefinitions().add((DropColumnDefinitionSegment)each);
                    continue;
                }
                if (each instanceof AddConstraintDefinitionSegment) {
                    result.getAddConstraintDefinitions().add((AddConstraintDefinitionSegment)each);
                    continue;
                }
                if (each instanceof ModifyConstraintDefinitionSegment) {
                    result.getModifyConstraintDefinitions().add((ModifyConstraintDefinitionSegment)each);
                    continue;
                }
                if (!(each instanceof DropConstraintDefinitionSegment)) continue;
                result.getDropConstraintDefinitions().add((DropConstraintDefinitionSegment)each);
            }
        }
        return result;
    }

    @Override
    public ASTNode visitAlterDefinitionClause(SQLServerStatementParser.AlterDefinitionClauseContext ctx) {
        CollectionValue result = new CollectionValue();
        if (null != ctx.addColumnSpecification()) {
            result.getValue().addAll(((CollectionValue)this.visit((ParseTree)ctx.addColumnSpecification())).getValue());
        }
        if (null != ctx.modifyColumnSpecification()) {
            result.getValue().add((ModifyColumnDefinitionSegment)this.visit((ParseTree)ctx.modifyColumnSpecification()));
        }
        if (null != ctx.alterDrop() && null != ctx.alterDrop().dropColumnSpecification()) {
            result.getValue().add((DropColumnDefinitionSegment)this.visit((ParseTree)ctx.alterDrop().dropColumnSpecification()));
        }
        if (null != ctx.alterDrop() && null != ctx.alterDrop().alterTableDropConstraint()) {
            result.combine((CollectionValue)this.visit((ParseTree)ctx.alterDrop().alterTableDropConstraint()));
        }
        if (null != ctx.alterCheckConstraint()) {
            result.getValue().add((AlterDefinitionSegment)this.visit((ParseTree)ctx.alterCheckConstraint()));
        }
        return result;
    }

    @Override
    public ASTNode visitAddColumnSpecification(SQLServerStatementParser.AddColumnSpecificationContext ctx) {
        CollectionValue result = new CollectionValue();
        if (null != ctx.alterColumnAddOptions()) {
            for (SQLServerStatementParser.AlterColumnAddOptionContext each : ctx.alterColumnAddOptions().alterColumnAddOption()) {
                if (null == each.columnDefinition()) continue;
                AddColumnDefinitionSegment addColumnDefinition = new AddColumnDefinitionSegment(each.columnDefinition().getStart().getStartIndex(), each.columnDefinition().getStop().getStopIndex(), Collections.singletonList((ColumnDefinitionSegment)this.visit((ParseTree)each.columnDefinition())));
                result.getValue().add(addColumnDefinition);
            }
        }
        return result;
    }

    @Override
    public ASTNode visitModifyColumnSpecification(SQLServerStatementParser.ModifyColumnSpecificationContext ctx) {
        ColumnSegment column = (ColumnSegment)this.visit((ParseTree)ctx.alterColumnOperation().columnName());
        DataTypeSegment dataType = (DataTypeSegment)this.visit((ParseTree)ctx.dataType());
        ColumnDefinitionSegment columnDefinition = new ColumnDefinitionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), column, dataType, false, false);
        return new ModifyColumnDefinitionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), columnDefinition);
    }

    @Override
    public ASTNode visitDropColumnSpecification(SQLServerStatementParser.DropColumnSpecificationContext ctx) {
        LinkedList<ColumnSegment> columns = new LinkedList<ColumnSegment>();
        for (SQLServerStatementParser.ColumnNameContext each : ctx.columnName()) {
            columns.add((ColumnSegment)this.visit((ParseTree)each));
        }
        return new DropColumnDefinitionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), columns);
    }

    @Override
    public ASTNode visitDropTable(SQLServerStatementParser.DropTableContext ctx) {
        SQLServerDropTableStatement result = new SQLServerDropTableStatement(null != ctx.ifExists());
        result.getTables().addAll(((CollectionValue)this.visit((ParseTree)ctx.tableNames())).getValue());
        return result;
    }

    @Override
    public ASTNode visitTruncateTable(SQLServerStatementParser.TruncateTableContext ctx) {
        SQLServerTruncateStatement result = new SQLServerTruncateStatement();
        result.getTables().add((SimpleTableSegment)this.visit((ParseTree)ctx.tableName()));
        return result;
    }

    @Override
    public ASTNode visitCreateIndex(SQLServerStatementParser.CreateIndexContext ctx) {
        SQLServerCreateIndexStatement result = new SQLServerCreateIndexStatement();
        result.setTable((SimpleTableSegment)this.visit((ParseTree)ctx.tableName()));
        result.setIndex((IndexSegment)this.visit((ParseTree)ctx.indexName()));
        result.getColumns().addAll(((CollectionValue)this.visit((ParseTree)ctx.columnNamesWithSort())).getValue());
        return result;
    }

    @Override
    public ASTNode visitColumnNameWithSort(SQLServerStatementParser.ColumnNameWithSortContext ctx) {
        return (ASTNode)this.visit((ParseTree)ctx.columnName());
    }

    @Override
    public ASTNode visitAlterIndex(SQLServerStatementParser.AlterIndexContext ctx) {
        SQLServerAlterIndexStatement result = new SQLServerAlterIndexStatement();
        if (null != ctx.indexName()) {
            result.setIndex((IndexSegment)this.visit((ParseTree)ctx.indexName()));
        }
        result.setSimpleTable((SimpleTableSegment)this.visit((ParseTree)ctx.tableName()));
        return result;
    }

    @Override
    public ASTNode visitDropIndex(SQLServerStatementParser.DropIndexContext ctx) {
        SQLServerDropIndexStatement result = new SQLServerDropIndexStatement(null != ctx.ifExists());
        result.getIndexes().add((IndexSegment)this.visit((ParseTree)ctx.indexName()));
        result.setSimpleTable((SimpleTableSegment)this.visit((ParseTree)ctx.tableName()));
        return result;
    }

    @Override
    public ASTNode visitAlterCheckConstraint(SQLServerStatementParser.AlterCheckConstraintContext ctx) {
        return new ModifyConstraintDefinitionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), (ConstraintSegment)this.visit((ParseTree)ctx.constraintName()));
    }

    @Override
    public ASTNode visitAlterTableDropConstraint(SQLServerStatementParser.AlterTableDropConstraintContext ctx) {
        CollectionValue result = new CollectionValue();
        for (SQLServerStatementParser.DropConstraintNameContext each : ctx.dropConstraintName()) {
            result.getValue().add(new DropConstraintDefinitionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), (ConstraintSegment)this.visit((ParseTree)each.constraintName())));
        }
        return result;
    }

    @Override
    public ASTNode visitCreateDatabase(SQLServerStatementParser.CreateDatabaseContext ctx) {
        SQLServerCreateDatabaseStatement result = new SQLServerCreateDatabaseStatement();
        result.setDatabaseName(ctx.databaseName().getText());
        return result;
    }

    @Override
    public ASTNode visitCreateFunction(SQLServerStatementParser.CreateFunctionContext ctx) {
        return new SQLServerCreateFunctionStatement();
    }

    @Override
    public ASTNode visitCreateProcedure(SQLServerStatementParser.CreateProcedureContext ctx) {
        return new SQLServerCreateProcedureStatement();
    }

    @Override
    public ASTNode visitCreateView(SQLServerStatementParser.CreateViewContext ctx) {
        SQLServerCreateViewStatement result = new SQLServerCreateViewStatement();
        result.setView((SimpleTableSegment)this.visit((ParseTree)ctx.viewName()));
        result.setViewDefinition(this.getOriginalText(ctx.createOrAlterViewClause().select()));
        result.setSelect((SelectStatement)((SQLServerSelectStatement)this.visit((ParseTree)ctx.createOrAlterViewClause().select())));
        return result;
    }

    @Override
    public ASTNode visitCreateTrigger(SQLServerStatementParser.CreateTriggerContext ctx) {
        return new SQLServerCreateTriggerStatement();
    }

    @Override
    public ASTNode visitCreateSequence(SQLServerStatementParser.CreateSequenceContext ctx) {
        SQLServerCreateSequenceStatement result = new SQLServerCreateSequenceStatement();
        result.setSequenceName(ctx.sequenceName().name().getText());
        return result;
    }

    @Override
    public ASTNode visitCreateSchema(SQLServerStatementParser.CreateSchemaContext ctx) {
        return new SQLServerCreateSchemaStatement();
    }

    @Override
    public ASTNode visitCreateService(SQLServerStatementParser.CreateServiceContext ctx) {
        return new SQLServerCreateServiceStatement();
    }

    @Override
    public ASTNode visitAlterSchema(SQLServerStatementParser.AlterSchemaContext ctx) {
        return new SQLServerAlterSchemaStatement();
    }

    @Override
    public ASTNode visitAlterService(SQLServerStatementParser.AlterServiceContext ctx) {
        return new SQLServerAlterServiceStatement();
    }

    @Override
    public ASTNode visitDropSchema(SQLServerStatementParser.DropSchemaContext ctx) {
        return new SQLServerDropSchemaStatement();
    }

    @Override
    public ASTNode visitDropService(SQLServerStatementParser.DropServiceContext ctx) {
        return new SQLServerDropServiceStatement();
    }

    @Override
    public ASTNode visitAlterTrigger(SQLServerStatementParser.AlterTriggerContext ctx) {
        return new SQLServerAlterTriggerStatement();
    }

    @Override
    public ASTNode visitAlterSequence(SQLServerStatementParser.AlterSequenceContext ctx) {
        return new SQLServerAlterSequenceStatement();
    }

    @Override
    public ASTNode visitAlterProcedure(SQLServerStatementParser.AlterProcedureContext ctx) {
        return new SQLServerAlterProcedureStatement();
    }

    @Override
    public ASTNode visitAlterFunction(SQLServerStatementParser.AlterFunctionContext ctx) {
        return new SQLServerAlterFunctionStatement();
    }

    @Override
    public ASTNode visitAlterView(SQLServerStatementParser.AlterViewContext ctx) {
        SQLServerAlterViewStatement result = new SQLServerAlterViewStatement();
        result.setView((SimpleTableSegment)this.visit((ParseTree)ctx.viewName()));
        result.setViewDefinition(this.getOriginalText(ctx.createOrAlterViewClause().select()));
        result.setSelect((SelectStatement)((SQLServerSelectStatement)this.visit((ParseTree)ctx.createOrAlterViewClause().select())));
        return result;
    }

    @Override
    public ASTNode visitAlterDatabase(SQLServerStatementParser.AlterDatabaseContext ctx) {
        return new SQLServerAlterDatabaseStatement();
    }

    @Override
    public ASTNode visitDropDatabase(SQLServerStatementParser.DropDatabaseContext ctx) {
        return new SQLServerDropDatabaseStatement();
    }

    @Override
    public ASTNode visitDropFunction(SQLServerStatementParser.DropFunctionContext ctx) {
        return new SQLServerDropFunctionStatement();
    }

    @Override
    public ASTNode visitDropProcedure(SQLServerStatementParser.DropProcedureContext ctx) {
        return new SQLServerDropProcedureStatement();
    }

    @Override
    public ASTNode visitDropView(SQLServerStatementParser.DropViewContext ctx) {
        SQLServerDropViewStatement result = new SQLServerDropViewStatement();
        for (SQLServerStatementParser.ViewNameContext each : ctx.viewName()) {
            result.getViews().add((SimpleTableSegment)this.visit((ParseTree)each));
        }
        return result;
    }

    @Override
    public ASTNode visitDropTrigger(SQLServerStatementParser.DropTriggerContext ctx) {
        return new SQLServerDropTriggerStatement();
    }

    @Override
    public ASTNode visitDropSequence(SQLServerStatementParser.DropSequenceContext ctx) {
        return new SQLServerDropSequenceStatement();
    }
}

