/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.shardingsphere.data.pipeline.cdc.config.yaml.config;

import lombok.Getter;
import lombok.Setter;
import org.apache.shardingsphere.data.pipeline.core.datasource.yaml.config.YamlPipelineDataSourceConfiguration;
import org.apache.shardingsphere.data.pipeline.core.job.config.yaml.config.YamlPipelineJobConfiguration;

import java.util.List;
import java.util.Properties;

/**
 * CDC job configuration for YAML.
 */
@Getter
@Setter
public final class YamlCDCJobConfiguration implements YamlPipelineJobConfiguration {
    
    private String jobId;
    
    private String databaseName;
    
    private List<String> schemaTableNames;
    
    private boolean full;
    
    private String sourceDatabaseType;
    
    private YamlPipelineDataSourceConfiguration dataSourceConfiguration;
    
    private String tablesFirstDataNodes;
    
    private List<String> jobShardingDataNodes;
    
    private boolean decodeWithTX;
    
    private YamlSinkConfiguration sinkConfig;
    
    private int concurrency = 1;
    
    private int retryTimes;
    
    /**
     * Sink configuration for YAML.
     */
    @Getter
    @Setter
    public static class YamlSinkConfiguration {
        
        private String sinkType;
        
        private Properties props;
    }
}
