/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.metadata.manager;

import java.sql.SQLException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.shardingsphere.infra.config.rule.RuleConfiguration;
import org.apache.shardingsphere.infra.config.rule.scope.DatabaseRuleConfiguration;
import org.apache.shardingsphere.infra.config.rule.scope.DatabaseRuleConfigurationEmptyChecker;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.instance.ComputeNodeInstanceContext;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.resource.ResourceMetaData;
import org.apache.shardingsphere.infra.rule.PartialRuleUpdateSupported;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.infra.rule.builder.database.DatabaseRulesBuilder;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;
import org.apache.shardingsphere.mode.metadata.MetaDataContexts;
import org.apache.shardingsphere.mode.metadata.MetaDataContextsFactory;
import org.apache.shardingsphere.mode.metadata.persist.MetaDataPersistService;
import org.apache.shardingsphere.mode.spi.repository.PersistRepository;

public final class DatabaseRuleConfigurationManager {
    private final MetaDataContexts metaDataContexts;
    private final ComputeNodeInstanceContext computeNodeInstanceContext;
    private final MetaDataPersistService metaDataPersistService;

    public DatabaseRuleConfigurationManager(MetaDataContexts metaDataContexts, ComputeNodeInstanceContext computeNodeInstanceContext, PersistRepository repository) {
        this.metaDataContexts = metaDataContexts;
        this.computeNodeInstanceContext = computeNodeInstanceContext;
        this.metaDataPersistService = new MetaDataPersistService(repository);
    }

    public synchronized void alterRuleConfiguration(String databaseName, RuleConfiguration ruleConfig) throws SQLException {
        ShardingSphereDatabase database = this.metaDataContexts.getMetaData().getDatabase(databaseName);
        LinkedList<ShardingSphereRule> rules = new LinkedList<ShardingSphereRule>(database.getRuleMetaData().getRules());
        Optional<ShardingSphereRule> toBeChangedRule = rules.stream().filter(each -> each.getConfiguration().getClass().equals(ruleConfig.getClass())).findFirst();
        if (toBeChangedRule.isPresent() && toBeChangedRule.get() instanceof PartialRuleUpdateSupported && ((PartialRuleUpdateSupported)toBeChangedRule.get()).partialUpdate(ruleConfig)) {
            ((PartialRuleUpdateSupported)toBeChangedRule.get()).updateConfiguration(ruleConfig);
            return;
        }
        rules.removeIf(each -> each.getConfiguration().getClass().isAssignableFrom(ruleConfig.getClass()));
        rules.addAll(DatabaseRulesBuilder.build((String)databaseName, (DatabaseType)database.getProtocolType(), (Collection)database.getRuleMetaData().getRules(), (RuleConfiguration)ruleConfig, (ComputeNodeInstanceContext)this.computeNodeInstanceContext, (ResourceMetaData)database.getResourceMetaData()));
        this.refreshMetadata(databaseName, this.getRuleConfigurations(rules));
    }

    public synchronized void dropRuleConfiguration(String databaseName, RuleConfiguration ruleConfig) throws SQLException {
        ShardingSphereDatabase database = this.metaDataContexts.getMetaData().getDatabase(databaseName);
        LinkedList<ShardingSphereRule> rules = new LinkedList<ShardingSphereRule>(database.getRuleMetaData().getRules());
        Optional<ShardingSphereRule> toBeChangedRule = rules.stream().filter(each -> each.getConfiguration().getClass().equals(ruleConfig.getClass())).findFirst();
        if (toBeChangedRule.isPresent() && toBeChangedRule.get() instanceof PartialRuleUpdateSupported && ((PartialRuleUpdateSupported)toBeChangedRule.get()).partialUpdate(ruleConfig)) {
            ((PartialRuleUpdateSupported)toBeChangedRule.get()).updateConfiguration(ruleConfig);
            return;
        }
        rules.removeIf(each -> each.getConfiguration().getClass().isAssignableFrom(ruleConfig.getClass()));
        if (!((DatabaseRuleConfigurationEmptyChecker)TypedSPILoader.getService(DatabaseRuleConfigurationEmptyChecker.class, ruleConfig.getClass())).isEmpty((DatabaseRuleConfiguration)ruleConfig)) {
            rules.addAll(DatabaseRulesBuilder.build((String)databaseName, (DatabaseType)database.getProtocolType(), (Collection)database.getRuleMetaData().getRules(), (RuleConfiguration)ruleConfig, (ComputeNodeInstanceContext)this.computeNodeInstanceContext, (ResourceMetaData)database.getResourceMetaData()));
        }
        this.refreshMetadata(databaseName, this.getRuleConfigurations(rules));
    }

    private void refreshMetadata(String databaseName, Collection<RuleConfiguration> ruleConfigurations) throws SQLException {
        this.metaDataContexts.update(MetaDataContextsFactory.createByAlterRule(databaseName, false, ruleConfigurations, this.metaDataContexts, this.metaDataPersistService, this.computeNodeInstanceContext));
    }

    private Collection<RuleConfiguration> getRuleConfigurations(Collection<ShardingSphereRule> rules) {
        return rules.stream().map(ShardingSphereRule::getConfiguration).collect(Collectors.toList());
    }
}

