/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sqlfederation.optimizer.planner.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import lombok.Generated;
import org.apache.calcite.adapter.enumerable.EnumerableRules;
import org.apache.calcite.config.CalciteConnectionConfig;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.plan.ConventionTraitDef;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.calcite.plan.hep.HepMatchOrder;
import org.apache.calcite.plan.hep.HepPlanner;
import org.apache.calcite.plan.hep.HepProgramBuilder;
import org.apache.calcite.plan.volcano.VolcanoPlanner;
import org.apache.calcite.prepare.CalciteCatalogReader;
import org.apache.calcite.prepare.Prepare;
import org.apache.calcite.rel.RelCollationTraitDef;
import org.apache.calcite.rel.rules.AggregateExpandDistinctAggregatesRule;
import org.apache.calcite.rel.rules.CoreRules;
import org.apache.calcite.rel.rules.ProjectRemoveRule;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.sql.SqlOperatorTable;
import org.apache.calcite.sql.fun.SqlLibrary;
import org.apache.calcite.sql.fun.SqlLibraryOperatorTableFactory;
import org.apache.calcite.sql.util.SqlOperatorTables;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorCatalogReader;
import org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.apache.calcite.sql2rel.SqlRexConvertletTable;
import org.apache.calcite.sql2rel.SqlToRelConverter;
import org.apache.calcite.sql2rel.StandardConvertletTable;
import org.apache.shardingsphere.infra.database.core.spi.DatabaseTypedSPILoader;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.parser.rule.SQLParserRule;
import org.apache.shardingsphere.sqlfederation.optimizer.function.SQLFederationFunctionRegister;
import org.apache.shardingsphere.sqlfederation.optimizer.function.mysql.MySQLOperatorTable;
import org.apache.shardingsphere.sqlfederation.optimizer.metadata.view.ShardingSphereViewExpander;
import org.apache.shardingsphere.sqlfederation.optimizer.planner.rule.converter.EnumerableModifyConverterRule;
import org.apache.shardingsphere.sqlfederation.optimizer.planner.rule.converter.EnumerableScanConverterRule;
import org.apache.shardingsphere.sqlfederation.optimizer.planner.rule.transformation.PushFilterIntoScanRule;
import org.apache.shardingsphere.sqlfederation.optimizer.planner.rule.transformation.PushProjectIntoScanRule;

public final class SQLFederationPlannerUtils {
    private static final int DEFAULT_MATCH_LIMIT = 1024;
    private static final Map<String, SqlLibrary> DATABASE_TYPE_SQL_LIBRARIES = new HashMap<String, SqlLibrary>();

    public static RelOptPlanner createVolcanoPlanner() {
        VolcanoPlanner result = new VolcanoPlanner();
        SQLFederationPlannerUtils.setUpRules((RelOptPlanner)result);
        return result;
    }

    public static RelOptPlanner createHepPlanner() {
        HepProgramBuilder builder = new HepProgramBuilder();
        builder.addGroupBegin().addRuleCollection(SQLFederationPlannerUtils.getFilterRules()).addGroupEnd().addMatchOrder(HepMatchOrder.BOTTOM_UP);
        builder.addGroupBegin().addRuleCollection(SQLFederationPlannerUtils.getProjectRules()).addGroupEnd().addMatchOrder(HepMatchOrder.BOTTOM_UP);
        builder.addGroupBegin().addRuleCollection(SQLFederationPlannerUtils.getAggregationRules()).addGroupEnd().addMatchOrder(HepMatchOrder.BOTTOM_UP);
        builder.addGroupBegin().addRuleCollection(SQLFederationPlannerUtils.getCalcRules()).addGroupEnd().addMatchOrder(HepMatchOrder.BOTTOM_UP);
        builder.addGroupBegin().addRuleCollection(SQLFederationPlannerUtils.getSubQueryRules()).addGroupEnd().addMatchOrder(HepMatchOrder.BOTTOM_UP);
        builder.addMatchLimit(1024);
        return new HepPlanner(builder.build());
    }

    private static void setUpRules(RelOptPlanner planner) {
        planner.addRelTraitDef((RelTraitDef)ConventionTraitDef.INSTANCE);
        planner.addRelTraitDef((RelTraitDef)RelCollationTraitDef.INSTANCE);
        planner.addRule(EnumerableRules.ENUMERABLE_JOIN_RULE);
        planner.addRule(EnumerableRules.ENUMERABLE_MERGE_JOIN_RULE);
        planner.addRule(EnumerableRules.ENUMERABLE_CORRELATE_RULE);
        planner.addRule((RelOptRule)EnumerableRules.ENUMERABLE_PROJECT_RULE);
        planner.addRule((RelOptRule)EnumerableRules.ENUMERABLE_FILTER_RULE);
        planner.addRule((RelOptRule)EnumerableRules.ENUMERABLE_CALC_RULE);
        planner.addRule((RelOptRule)EnumerableRules.ENUMERABLE_AGGREGATE_RULE);
        planner.addRule((RelOptRule)EnumerableRules.ENUMERABLE_SORT_RULE);
        planner.addRule((RelOptRule)EnumerableRules.ENUMERABLE_LIMIT_RULE);
        planner.addRule((RelOptRule)EnumerableRules.ENUMERABLE_COLLECT_RULE);
        planner.addRule((RelOptRule)EnumerableRules.ENUMERABLE_UNCOLLECT_RULE);
        planner.addRule((RelOptRule)EnumerableRules.ENUMERABLE_UNION_RULE);
        planner.addRule((RelOptRule)EnumerableRules.ENUMERABLE_REPEAT_UNION_RULE);
        planner.addRule((RelOptRule)EnumerableRules.ENUMERABLE_TABLE_SPOOL_RULE);
        planner.addRule((RelOptRule)EnumerableRules.ENUMERABLE_INTERSECT_RULE);
        planner.addRule((RelOptRule)EnumerableRules.ENUMERABLE_MINUS_RULE);
        planner.addRule((RelOptRule)EnumerableRules.ENUMERABLE_VALUES_RULE);
        planner.addRule((RelOptRule)EnumerableRules.ENUMERABLE_WINDOW_RULE);
        planner.addRule((RelOptRule)EnumerableRules.ENUMERABLE_TABLE_SCAN_RULE);
        planner.addRule((RelOptRule)EnumerableRules.ENUMERABLE_TABLE_FUNCTION_SCAN_RULE);
        planner.addRule((RelOptRule)EnumerableRules.ENUMERABLE_MATCH_RULE);
        planner.addRule(EnumerableScanConverterRule.DEFAULT_CONFIG.toRule());
        planner.addRule(EnumerableModifyConverterRule.DEFAULT_CONFIG.toRule());
    }

    private static Collection<RelOptRule> getSubQueryRules() {
        LinkedList<RelOptRule> result = new LinkedList<RelOptRule>();
        result.add((RelOptRule)CoreRules.FILTER_SUB_QUERY_TO_CORRELATE);
        result.add((RelOptRule)CoreRules.PROJECT_SUB_QUERY_TO_CORRELATE);
        result.add((RelOptRule)CoreRules.JOIN_SUB_QUERY_TO_CORRELATE);
        return result;
    }

    private static Collection<RelOptRule> getCalcRules() {
        LinkedList<RelOptRule> result = new LinkedList<RelOptRule>();
        result.add((RelOptRule)AggregateExpandDistinctAggregatesRule.Config.DEFAULT.toRule());
        result.add((RelOptRule)CoreRules.PROJECT_TO_CALC);
        result.add((RelOptRule)CoreRules.FILTER_TO_CALC);
        result.add((RelOptRule)CoreRules.PROJECT_CALC_MERGE);
        result.add((RelOptRule)CoreRules.FILTER_CALC_MERGE);
        result.add((RelOptRule)EnumerableRules.ENUMERABLE_FILTER_TO_CALC_RULE);
        result.add((RelOptRule)EnumerableRules.ENUMERABLE_PROJECT_TO_CALC_RULE);
        result.add((RelOptRule)CoreRules.CALC_MERGE);
        return result;
    }

    private static Collection<RelOptRule> getProjectRules() {
        LinkedList<RelOptRule> result = new LinkedList<RelOptRule>();
        result.add((RelOptRule)CoreRules.PROJECT_MERGE);
        result.add((RelOptRule)CoreRules.PROJECT_CORRELATE_TRANSPOSE);
        result.add((RelOptRule)CoreRules.PROJECT_SET_OP_TRANSPOSE);
        result.add((RelOptRule)CoreRules.PROJECT_JOIN_TRANSPOSE);
        result.add((RelOptRule)CoreRules.PROJECT_REDUCE_EXPRESSIONS);
        result.add((RelOptRule)ProjectRemoveRule.Config.DEFAULT.toRule());
        result.add((RelOptRule)PushProjectIntoScanRule.Config.DEFAULT.toRule());
        return result;
    }

    private static Collection<RelOptRule> getFilterRules() {
        LinkedList<RelOptRule> result = new LinkedList<RelOptRule>();
        result.add((RelOptRule)CoreRules.FILTER_INTO_JOIN);
        result.add((RelOptRule)CoreRules.JOIN_CONDITION_PUSH);
        result.add((RelOptRule)CoreRules.SORT_JOIN_TRANSPOSE);
        result.add((RelOptRule)CoreRules.FILTER_AGGREGATE_TRANSPOSE);
        result.add((RelOptRule)CoreRules.FILTER_PROJECT_TRANSPOSE);
        result.add((RelOptRule)CoreRules.FILTER_SET_OP_TRANSPOSE);
        result.add((RelOptRule)CoreRules.FILTER_REDUCE_EXPRESSIONS);
        result.add((RelOptRule)CoreRules.FILTER_MERGE);
        result.add((RelOptRule)CoreRules.JOIN_PUSH_EXPRESSIONS);
        result.add((RelOptRule)CoreRules.JOIN_PUSH_TRANSITIVE_PREDICATES);
        result.add((RelOptRule)PushFilterIntoScanRule.Config.DEFAULT.toRule());
        return result;
    }

    private static Collection<RelOptRule> getAggregationRules() {
        LinkedList<RelOptRule> result = new LinkedList<RelOptRule>();
        result.add((RelOptRule)CoreRules.AGGREGATE_MERGE);
        result.add((RelOptRule)CoreRules.AGGREGATE_REDUCE_FUNCTIONS);
        return result;
    }

    public static CalciteCatalogReader createCatalogReader(String schemaName, Schema schema, RelDataTypeFactory relDataTypeFactory, CalciteConnectionConfig connectionConfig, DatabaseType databaseType) {
        CalciteSchema rootSchema = CalciteSchema.createRootSchema((boolean)true);
        rootSchema.add(schemaName, schema);
        DatabaseTypedSPILoader.findService(SQLFederationFunctionRegister.class, (DatabaseType)databaseType).ifPresent(optional -> optional.registerFunction(rootSchema.plus(), schemaName));
        return new CalciteCatalogReader(rootSchema, Collections.singletonList(schemaName), relDataTypeFactory, connectionConfig);
    }

    public static SqlValidator createSqlValidator(CalciteCatalogReader catalogReader, RelDataTypeFactory relDataTypeFactory, DatabaseType databaseType, CalciteConnectionConfig connectionConfig) {
        SqlValidator.Config validatorConfig = SqlValidator.Config.DEFAULT.withLenientOperatorLookup(connectionConfig.lenientOperatorLookup()).withConformance(connectionConfig.conformance()).withDefaultNullCollation(connectionConfig.defaultNullCollation()).withIdentifierExpansion(true);
        SqlOperatorTable sqlOperatorTable = SQLFederationPlannerUtils.getSQLOperatorTable(catalogReader, databaseType.getTrunkDatabaseType().orElse(databaseType));
        return SqlValidatorUtil.newValidator((SqlOperatorTable)sqlOperatorTable, (SqlValidatorCatalogReader)catalogReader, (RelDataTypeFactory)relDataTypeFactory, (SqlValidator.Config)validatorConfig);
    }

    private static SqlOperatorTable getSQLOperatorTable(CalciteCatalogReader catalogReader, DatabaseType databaseType) {
        return SqlOperatorTables.chain(Arrays.asList(new SqlOperatorTable[]{new MySQLOperatorTable(), SqlLibraryOperatorTableFactory.INSTANCE.getOperatorTable(Arrays.asList(SqlLibrary.STANDARD, DATABASE_TYPE_SQL_LIBRARIES.getOrDefault(databaseType.getType(), SqlLibrary.MYSQL))), catalogReader}));
    }

    public static SqlToRelConverter createSqlToRelConverter(CalciteCatalogReader catalogReader, SqlValidator validator, RelOptCluster cluster, SQLParserRule sqlParserRule, DatabaseType databaseType, boolean needsViewExpand) {
        RelOptTable.ViewExpander expander = needsViewExpand ? new ShardingSphereViewExpander(sqlParserRule, databaseType, SQLFederationPlannerUtils.createSqlToRelConverter(catalogReader, validator, cluster, sqlParserRule, databaseType, false)) : (rowType, queryString, schemaPath, viewPath) -> null;
        SqlToRelConverter.Config converterConfig = SqlToRelConverter.config().withTrimUnusedFields(true).withRemoveSortInSubQuery(false).withExpand(true);
        return new SqlToRelConverter(expander, validator, (Prepare.CatalogReader)catalogReader, cluster, (SqlRexConvertletTable)StandardConvertletTable.INSTANCE, converterConfig);
    }

    public static RelOptCluster createRelOptCluster(RelDataTypeFactory relDataTypeFactory) {
        return RelOptCluster.create((RelOptPlanner)SQLFederationPlannerUtils.createVolcanoPlanner(), (RexBuilder)new RexBuilder(relDataTypeFactory));
    }

    @Generated
    private SQLFederationPlannerUtils() {
    }

    static {
        DATABASE_TYPE_SQL_LIBRARIES.put("MySQL", SqlLibrary.MYSQL);
        DATABASE_TYPE_SQL_LIBRARIES.put("PostgreSQL", SqlLibrary.POSTGRESQL);
        DATABASE_TYPE_SQL_LIBRARIES.put("openGauss", SqlLibrary.POSTGRESQL);
        DATABASE_TYPE_SQL_LIBRARIES.put("Oracle", SqlLibrary.ORACLE);
    }
}

