/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.transaction.base.seata.at;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.seata.config.ConfigurationFactory;
import org.apache.seata.config.FileConfiguration;
import org.apache.seata.core.context.RootContext;
import org.apache.seata.core.rpc.netty.RmNettyRemotingClient;
import org.apache.seata.core.rpc.netty.TmNettyRemotingClient;
import org.apache.seata.rm.RMClient;
import org.apache.seata.rm.datasource.DataSourceProxy;
import org.apache.seata.tm.TMClient;
import org.apache.seata.tm.api.GlobalTransaction;
import org.apache.seata.tm.api.GlobalTransactionContext;
import org.apache.seata.tm.api.GlobalTransactionRole;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.transaction.api.TransactionType;
import org.apache.shardingsphere.transaction.base.seata.at.SeataTransactionHolder;
import org.apache.shardingsphere.transaction.base.seata.at.SeataXIDContext;
import org.apache.shardingsphere.transaction.base.seata.at.exception.SeataATApplicationIDNotFoundException;
import org.apache.shardingsphere.transaction.base.seata.at.exception.SeataATDisabledException;
import org.apache.shardingsphere.transaction.exception.TransactionTimeoutException;
import org.apache.shardingsphere.transaction.spi.ShardingSphereDistributedTransactionManager;

public final class SeataATShardingSphereTransactionManager
implements ShardingSphereDistributedTransactionManager {
    private final Map<String, DataSource> dataSourceMap = new HashMap<String, DataSource>();
    private final String applicationId;
    private final String transactionServiceGroup;
    private final boolean enableSeataAT;
    private final int globalTXTimeout;

    public SeataATShardingSphereTransactionManager() {
        FileConfiguration config = new FileConfiguration("seata.conf");
        this.enableSeataAT = config.getBoolean("shardingsphere.transaction.seata.at.enable", true);
        this.applicationId = config.getConfig("client.application.id");
        this.transactionServiceGroup = config.getConfig("client.transaction.service.group", "default");
        this.globalTXTimeout = config.getInt("shardingsphere.transaction.seata.tx.timeout", 60);
    }

    public void init(Map<String, DatabaseType> databaseTypes, Map<String, DataSource> dataSources, String providerType) {
        if (this.enableSeataAT) {
            this.initSeataRPCClient();
            dataSources.forEach((key, value) -> this.dataSourceMap.put((String)key, (DataSource)new DataSourceProxy(value)));
        }
    }

    private void initSeataRPCClient() {
        ShardingSpherePreconditions.checkNotNull((Object)this.applicationId, SeataATApplicationIDNotFoundException::new);
        TMClient.init((String)this.applicationId, (String)this.transactionServiceGroup);
        RMClient.init((String)this.applicationId, (String)this.transactionServiceGroup);
    }

    public TransactionType getTransactionType() {
        return TransactionType.BASE;
    }

    public boolean isInTransaction() {
        this.checkSeataATEnabled();
        return null != SeataTransactionHolder.get();
    }

    public Connection getConnection(String databaseName, String dataSourceName) throws SQLException {
        this.checkSeataATEnabled();
        return this.dataSourceMap.get(databaseName + "." + dataSourceName).getConnection();
    }

    public void begin() {
        this.begin(this.globalTXTimeout);
    }

    public void begin(int timeout) {
        ShardingSpherePreconditions.checkState((timeout >= 0 ? 1 : 0) != 0, TransactionTimeoutException::new);
        this.checkSeataATEnabled();
        GlobalTransaction globalTransaction = GlobalTransactionContext.getCurrentOrCreate();
        globalTransaction.begin(timeout * 1000);
        SeataTransactionHolder.set(globalTransaction);
    }

    public void commit(boolean rollbackOnly) {
        this.checkSeataATEnabled();
        GlobalTransaction globalTransaction = SeataTransactionHolder.get();
        try {
            globalTransaction.commit();
        }
        finally {
            if (GlobalTransactionRole.Participant != globalTransaction.getGlobalTransactionRole()) {
                SeataTransactionHolder.clear();
                RootContext.unbind();
                SeataXIDContext.remove();
            }
        }
    }

    public void rollback() {
        this.checkSeataATEnabled();
        try {
            SeataTransactionHolder.get().rollback();
        }
        finally {
            SeataTransactionHolder.clear();
            RootContext.unbind();
            SeataXIDContext.remove();
        }
    }

    private void checkSeataATEnabled() {
        ShardingSpherePreconditions.checkState((boolean)this.enableSeataAT, SeataATDisabledException::new);
    }

    public boolean containsProviderType(String providerType) {
        return true;
    }

    public void close() {
        this.dataSourceMap.clear();
        SeataTransactionHolder.clear();
        RmNettyRemotingClient.getInstance().destroy();
        TmNettyRemotingClient.getInstance().destroy();
        ConfigurationFactory.reload();
    }

    public String getType() {
        return TransactionType.BASE.name();
    }
}

