/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.metadata.reviser;

import java.util.Optional;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.config.props.ConfigurationPropertyKey;
import org.apache.shardingsphere.infra.metadata.database.schema.reviser.MetaDataReviseEntry;
import org.apache.shardingsphere.sharding.metadata.reviser.column.ShardingColumnGeneratedReviser;
import org.apache.shardingsphere.sharding.metadata.reviser.constraint.ShardingConstraintReviser;
import org.apache.shardingsphere.sharding.metadata.reviser.index.ShardingIndexReviser;
import org.apache.shardingsphere.sharding.metadata.reviser.schema.ShardingSchemaTableAggregationReviser;
import org.apache.shardingsphere.sharding.metadata.reviser.table.ShardingTableNameReviser;
import org.apache.shardingsphere.sharding.rule.ShardingRule;

public final class ShardingMetaDataReviseEntry
implements MetaDataReviseEntry<ShardingRule> {
    public Optional<ShardingSchemaTableAggregationReviser> getSchemaTableAggregationReviser(ConfigurationProperties props) {
        return Optional.of(new ShardingSchemaTableAggregationReviser((Boolean)props.getValue((Enum)ConfigurationPropertyKey.CHECK_TABLE_METADATA_ENABLED)));
    }

    public Optional<ShardingTableNameReviser> getTableNameReviser() {
        return Optional.of(new ShardingTableNameReviser());
    }

    public Optional<ShardingColumnGeneratedReviser> getColumnGeneratedReviser(ShardingRule rule, String tableName) {
        return rule.findShardingTableByActualTable(tableName).map(ShardingColumnGeneratedReviser::new);
    }

    public Optional<ShardingIndexReviser> getIndexReviser(ShardingRule rule, String tableName) {
        return rule.findShardingTableByActualTable(tableName).map(ShardingIndexReviser::new);
    }

    public Optional<ShardingConstraintReviser> getConstraintReviser(ShardingRule rule, String tableName) {
        return rule.findShardingTableByActualTable(tableName).map(ShardingConstraintReviser::new);
    }

    public int getOrder() {
        return 0;
    }

    public Class<ShardingRule> getTypeClass() {
        return ShardingRule.class;
    }
}

