/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.single.rule.changed;

import java.util.Collection;
import java.util.LinkedHashSet;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.util.yaml.YamlEngine;
import org.apache.shardingsphere.mode.spi.rule.RuleItemConfigurationChangedProcessor;
import org.apache.shardingsphere.mode.spi.rule.item.alter.AlterRuleItem;
import org.apache.shardingsphere.mode.spi.rule.item.drop.DropRuleItem;
import org.apache.shardingsphere.single.config.SingleRuleConfiguration;
import org.apache.shardingsphere.single.rule.SingleRule;

public final class SingleTableChangedProcessor
implements RuleItemConfigurationChangedProcessor<SingleRuleConfiguration, SingleRuleConfiguration> {
    public SingleRuleConfiguration swapRuleItemConfiguration(AlterRuleItem alterRuleItem, String yamlContent) {
        return new SingleRuleConfiguration((Collection)YamlEngine.unmarshal((String)yamlContent, LinkedHashSet.class), null);
    }

    public SingleRuleConfiguration findRuleConfiguration(ShardingSphereDatabase database) {
        return database.getRuleMetaData().findSingleRule(SingleRule.class).map(SingleRule::getConfiguration).orElseGet(SingleRuleConfiguration::new);
    }

    public void changeRuleItemConfiguration(AlterRuleItem alterRuleItem, SingleRuleConfiguration currentRuleConfig, SingleRuleConfiguration toBeChangedItemConfig) {
        currentRuleConfig.getTables().clear();
        currentRuleConfig.getTables().addAll(toBeChangedItemConfig.getTables());
    }

    public void dropRuleItemConfiguration(DropRuleItem dropRuleItem, SingleRuleConfiguration currentRuleConfig) {
        currentRuleConfig.getTables().clear();
    }

    public String getType() {
        return "single.tables";
    }
}

