/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.yaml.config.swapper.resource;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.shardingsphere.infra.datasource.pool.creator.DataSourcePoolCreator;
import org.apache.shardingsphere.infra.datasource.pool.props.domain.DataSourcePoolProperties;
import org.apache.shardingsphere.infra.yaml.config.pojo.YamlRootConfiguration;

public final class YamlDataSourceConfigurationSwapper {
    private static final String DATA_SOURCE_CLASS_NAME_KEY = "dataSourceClassName";
    private static final String CUSTOM_POOL_PROPS_KEY = "customPoolProps";

    public Map<String, DataSource> swapToDataSources(Map<String, Map<String, Object>> yamlDataSources) {
        return this.swapToDataSources(yamlDataSources, true);
    }

    public Map<String, DataSource> swapToDataSources(Map<String, Map<String, Object>> yamlDataSources, boolean cacheEnabled) {
        return DataSourcePoolCreator.create(yamlDataSources.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> this.swapToDataSourcePoolProperties((Map)entry.getValue()))), (boolean)cacheEnabled);
    }

    public Map<String, DataSourcePoolProperties> getDataSourcePoolPropertiesMap(YamlRootConfiguration yamlRootConfig) {
        Map<String, Map<String, Object>> yamlDataSourceConfigs = yamlRootConfig.getDataSources();
        LinkedHashMap<String, DataSourcePoolProperties> result = new LinkedHashMap<String, DataSourcePoolProperties>(yamlDataSourceConfigs.size(), 1.0f);
        yamlDataSourceConfigs.forEach((key, value) -> result.put((String)key, this.swapToDataSourcePoolProperties((Map<String, Object>)value)));
        return result;
    }

    public DataSourcePoolProperties swapToDataSourcePoolProperties(Map<String, Object> yamlConfig) {
        Preconditions.checkState((boolean)yamlConfig.containsKey(DATA_SOURCE_CLASS_NAME_KEY), (String)"%s can not be null.", (Object)DATA_SOURCE_CLASS_NAME_KEY);
        return new DataSourcePoolProperties(yamlConfig.get(DATA_SOURCE_CLASS_NAME_KEY).toString(), this.getProperties(yamlConfig));
    }

    private Map<String, Object> getProperties(Map<String, Object> yamlConfig) {
        HashMap<String, Object> result = new HashMap<String, Object>(yamlConfig);
        if ("com.zaxxer.hikari.HikariDataSource".equals(result.get(DATA_SOURCE_CLASS_NAME_KEY).toString())) {
            result.remove(DATA_SOURCE_CLASS_NAME_KEY);
        }
        if (null != yamlConfig.get(CUSTOM_POOL_PROPS_KEY)) {
            result.putAll((Map)yamlConfig.get(CUSTOM_POOL_PROPS_KEY));
        }
        result.remove(CUSTOM_POOL_PROPS_KEY);
        return result;
    }

    public Map<String, Object> swapToMap(DataSourcePoolProperties props) {
        HashMap<String, Object> result = new HashMap<String, Object>(props.getAllStandardProperties());
        result.put(DATA_SOURCE_CLASS_NAME_KEY, props.getPoolClassName());
        return result;
    }
}

