/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.context.segment.table;

import com.cedarsoftware.util.CaseInsensitiveSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.context.segment.select.subquery.SubqueryTableContext;
import org.apache.shardingsphere.infra.binder.context.segment.select.subquery.engine.SubqueryTableContextEngine;
import org.apache.shardingsphere.infra.binder.context.statement.dml.SelectStatementContext;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SubqueryTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.TableNameSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.TableSegment;

public final class TablesContext {
    private final Collection<TableSegment> tables = new LinkedList<TableSegment>();
    private final Collection<SimpleTableSegment> simpleTables = new LinkedList<SimpleTableSegment>();
    private final Collection<String> tableNames = new CaseInsensitiveSet();
    private final Collection<String> schemaNames = new CaseInsensitiveSet();
    private final Collection<String> databaseNames = new CaseInsensitiveSet();
    private final Map<String, Collection<SubqueryTableContext>> subqueryTables = new HashMap<String, Collection<SubqueryTableContext>>();

    public TablesContext(SimpleTableSegment table) {
        this(null == table ? Collections.emptyList() : Collections.singletonList(table));
    }

    public TablesContext(Collection<SimpleTableSegment> tables) {
        this(tables, Collections.emptyMap());
    }

    public TablesContext(Collection<? extends TableSegment> tables, Map<Integer, SelectStatementContext> subqueryContexts) {
        if (tables.isEmpty()) {
            return;
        }
        this.tables.addAll(tables);
        for (TableSegment tableSegment : tables) {
            SimpleTableSegment simpleTableSegment;
            TableNameSegment tableName;
            if (tableSegment instanceof SimpleTableSegment && !"DUAL".equalsIgnoreCase((tableName = (simpleTableSegment = (SimpleTableSegment)tableSegment).getTableName()).getIdentifier().getValue())) {
                this.simpleTables.add(simpleTableSegment);
                this.tableNames.add(tableName.getIdentifier().getValue());
                tableName.getTableBoundInfo().ifPresent(optional -> this.schemaNames.add(optional.getOriginalSchema().getValue()));
                tableName.getTableBoundInfo().ifPresent(optional -> this.databaseNames.add(optional.getOriginalDatabase().getValue()));
            }
            if (!(tableSegment instanceof SubqueryTableSegment)) continue;
            this.subqueryTables.putAll(this.createSubqueryTables(subqueryContexts, (SubqueryTableSegment)tableSegment));
        }
    }

    private Map<String, Collection<SubqueryTableContext>> createSubqueryTables(Map<Integer, SelectStatementContext> subqueryContexts, SubqueryTableSegment subqueryTable) {
        if (!subqueryContexts.containsKey(subqueryTable.getSubquery().getStartIndex())) {
            return Collections.emptyMap();
        }
        SelectStatementContext subqueryContext = subqueryContexts.get(subqueryTable.getSubquery().getStartIndex());
        Map<String, SubqueryTableContext> subqueryTableContexts = new SubqueryTableContextEngine().createSubqueryTableContexts(subqueryContext, subqueryTable.getAliasName().orElse(null));
        HashMap<String, Collection<SubqueryTableContext>> result = new HashMap<String, Collection<SubqueryTableContext>>(subqueryTableContexts.size(), 1.0f);
        for (SubqueryTableContext each : subqueryTableContexts.values()) {
            if (null == each.getAliasName()) continue;
            result.computeIfAbsent(each.getAliasName(), unused -> new LinkedList()).add(each);
        }
        return result;
    }

    public Optional<String> getDatabaseName() {
        return this.databaseNames.isEmpty() ? Optional.empty() : Optional.of(this.databaseNames.iterator().next());
    }

    public Optional<String> getSchemaName() {
        return this.schemaNames.isEmpty() ? Optional.empty() : Optional.of(this.schemaNames.iterator().next());
    }

    @Generated
    public Collection<SimpleTableSegment> getSimpleTables() {
        return this.simpleTables;
    }

    @Generated
    public Collection<String> getTableNames() {
        return this.tableNames;
    }

    @Generated
    public Collection<String> getSchemaNames() {
        return this.schemaNames;
    }

    @Generated
    public Collection<String> getDatabaseNames() {
        return this.databaseNames;
    }

    @Generated
    public String toString() {
        return "TablesContext(tables=" + this.tables + ", simpleTables=" + this.getSimpleTables() + ", tableNames=" + this.getTableNames() + ", schemaNames=" + this.getSchemaNames() + ", databaseNames=" + this.getDatabaseNames() + ", subqueryTables=" + this.subqueryTables + ")";
    }
}

