/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.expr.interval;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.Year;
import java.time.YearMonth;
import java.time.chrono.Chronology;
import java.time.chrono.IsoChronology;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.expr.spi.InlineExpressionParser;

public class IntervalInlineExpressionParser
implements InlineExpressionParser {
    private static final String PREFIX_KEY = "P";
    private static final String SUFFIX_PATTERN_KEY = "SP";
    private static final String INTERVAL_AMOUNT_KEY = "DIA";
    private static final String INTERVAL_UNIT_KEY = "DIU";
    private static final String DATE_TIME_LOWER_KEY = "DL";
    private static final String DATE_TIME_UPPER_KEY = "DU";
    private static final String CHRONOLOGY_KEY = "C";
    private TemporalAccessor startTime;
    private TemporalAccessor endTime;
    private String prefix;
    private DateTimeFormatter dateTimeFormatterForSuffixPattern;
    private int stepAmount;
    private ChronoUnit stepUnit;

    public void init(Properties props) {
        String inlineExpression = props.getProperty("inlineExpression");
        Map<String, String> propsMap = Arrays.stream(inlineExpression.split(";")).collect(Collectors.toMap(key -> key.split("=")[0], value -> value.split("=")[1]));
        this.prefix = this.getPrefix(propsMap);
        this.dateTimeFormatterForSuffixPattern = this.getSuffixPattern(propsMap);
        this.startTime = this.getDateTimeLower(propsMap);
        this.endTime = this.getDateTimeUpper(propsMap);
        this.stepAmount = this.getStepAmount(propsMap);
        this.stepUnit = this.getStepUnit(propsMap);
    }

    private String getPrefix(Map<String, String> props) {
        ShardingSpherePreconditions.checkContainsKey(props, (Object)PREFIX_KEY, () -> new RuntimeException(String.format("%s can not be null.", PREFIX_KEY)));
        return props.get(PREFIX_KEY);
    }

    private TemporalAccessor getDateTimeLower(Map<String, String> props) {
        ShardingSpherePreconditions.checkContainsKey(props, (Object)DATE_TIME_LOWER_KEY, () -> new RuntimeException(String.format("%s can not be null.", DATE_TIME_LOWER_KEY)));
        return this.getDateTime(props.get(DATE_TIME_LOWER_KEY));
    }

    private TemporalAccessor getDateTimeUpper(Map<String, String> props) {
        ShardingSpherePreconditions.checkContainsKey(props, (Object)DATE_TIME_UPPER_KEY, () -> new RuntimeException(String.format("%s can not be null.", DATE_TIME_UPPER_KEY)));
        return this.getDateTime(props.get(DATE_TIME_UPPER_KEY));
    }

    private TemporalAccessor getDateTime(String dateTimeValue) {
        return this.dateTimeFormatterForSuffixPattern.parse(dateTimeValue);
    }

    private DateTimeFormatter getSuffixPattern(Map<String, String> props) {
        String suffix = props.get(SUFFIX_PATTERN_KEY);
        ShardingSpherePreconditions.checkNotEmpty((String)suffix, () -> new RuntimeException(String.format("%s can not be null or empty.", SUFFIX_PATTERN_KEY)));
        Chronology chronology = this.getChronology(props);
        return DateTimeFormatter.ofPattern(suffix).withChronology(chronology);
    }

    private int getStepAmount(Map<String, String> props) {
        ShardingSpherePreconditions.checkContainsKey(props, (Object)INTERVAL_AMOUNT_KEY, () -> new RuntimeException(String.format("%s can not be null.", INTERVAL_AMOUNT_KEY)));
        return Integer.parseInt(props.get(INTERVAL_AMOUNT_KEY));
    }

    private ChronoUnit getStepUnit(Map<String, String> props) {
        ShardingSpherePreconditions.checkContainsKey(props, (Object)INTERVAL_UNIT_KEY, () -> new RuntimeException(String.format("%s can not be null.", INTERVAL_UNIT_KEY)));
        String stepUnit = props.get(INTERVAL_UNIT_KEY);
        return Arrays.stream(ChronoUnit.values()).filter(chronoUnit -> chronoUnit.toString().equals(stepUnit)).findFirst().orElseThrow(() -> new RuntimeException(String.format("Cannot find step unit for specified %s property: `%s`", INTERVAL_UNIT_KEY, stepUnit)));
    }

    private Chronology getChronology(Map<String, String> props) {
        if (props.containsKey(CHRONOLOGY_KEY)) {
            String chronology = props.get(CHRONOLOGY_KEY);
            return Chronology.getAvailableChronologies().stream().filter(chronologyInstance -> chronologyInstance.getId().equals(chronology)).findFirst().orElseThrow(() -> new RuntimeException(String.format("Cannot find chronology for specified %s property: `%s`", CHRONOLOGY_KEY, chronology)));
        }
        return IsoChronology.INSTANCE;
    }

    public List<String> splitAndEvaluate() {
        TemporalAccessor calculateTime = this.startTime;
        if (!calculateTime.isSupported(ChronoField.NANO_OF_DAY)) {
            if (calculateTime.isSupported(ChronoField.EPOCH_DAY)) {
                return this.convertStringFromTemporal(this.startTime.query(LocalDate::from), this.endTime.query(LocalDate::from));
            }
            if (calculateTime.isSupported(ChronoField.YEAR) && calculateTime.isSupported(ChronoField.MONTH_OF_YEAR)) {
                return this.convertStringFromTemporal(this.startTime.query(YearMonth::from), this.endTime.query(YearMonth::from));
            }
            if (calculateTime.isSupported(ChronoField.YEAR)) {
                return this.convertStringFromTemporal(this.startTime.query(Year::from), this.endTime.query(Year::from));
            }
            if (calculateTime.isSupported(ChronoField.MONTH_OF_YEAR)) {
                return this.convertStringFromMonth();
            }
        }
        if (!calculateTime.isSupported(ChronoField.EPOCH_DAY)) {
            return this.convertStringFromTemporal(this.startTime.query(LocalTime::from), this.endTime.query(LocalTime::from));
        }
        return this.convertStringFromTemporal(this.startTime.query(LocalDateTime::from), this.endTime.query(LocalDateTime::from));
    }

    private List<String> convertStringFromMonth() {
        Month startTimeAsMonth = this.startTime.query(Month::from);
        Month endTimeAsMonth = this.endTime.query(Month::from);
        return LongStream.iterate(0L, x -> x + (long)this.stepAmount).limit((long)((endTimeAsMonth.getValue() - startTimeAsMonth.getValue()) / this.stepAmount) + 1L).parallel().boxed().map(startTimeAsMonth::plus).map(this.dateTimeFormatterForSuffixPattern::format).map(suffix -> this.prefix + suffix).collect(Collectors.toList());
    }

    private List<String> convertStringFromTemporal(Temporal startTimeAsTemporal, Temporal endTimeAsTemporal) {
        return LongStream.iterate(0L, x -> x + (long)this.stepAmount).limit(this.stepUnit.between(startTimeAsTemporal, endTimeAsTemporal) / (long)this.stepAmount + 1L).parallel().boxed().map(arithmeticSequence -> startTimeAsTemporal.plus((long)arithmeticSequence, this.stepUnit)).map(this.dateTimeFormatterForSuffixPattern::format).map(suffix -> this.prefix + suffix).collect(Collectors.toList());
    }

    public String getType() {
        return "INTERVAL";
    }
}

