/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.readwritesplitting.rule;

import java.util.Collection;
import java.util.HashSet;
import lombok.Generated;
import org.apache.shardingsphere.infra.algorithm.loadbalancer.core.LoadBalanceAlgorithm;
import org.apache.shardingsphere.readwritesplitting.config.rule.ReadwriteSplittingDataSourceGroupRuleConfiguration;
import org.apache.shardingsphere.readwritesplitting.group.ReadwriteSplittingGroup;
import org.apache.shardingsphere.readwritesplitting.group.type.StaticReadwriteSplittingGroup;
import org.apache.shardingsphere.readwritesplitting.transaction.TransactionalReadQueryStrategy;

public final class ReadwriteSplittingDataSourceGroupRule {
    private final String name;
    private final TransactionalReadQueryStrategy transactionalReadQueryStrategy;
    private final LoadBalanceAlgorithm loadBalancer;
    private final ReadwriteSplittingGroup readwriteSplittingGroup;
    private final Collection<String> disabledDataSourceNames = new HashSet<String>();

    public ReadwriteSplittingDataSourceGroupRule(ReadwriteSplittingDataSourceGroupRuleConfiguration config, TransactionalReadQueryStrategy transactionalReadQueryStrategy, LoadBalanceAlgorithm loadBalancer) {
        this.name = config.getName();
        this.transactionalReadQueryStrategy = transactionalReadQueryStrategy;
        this.loadBalancer = loadBalancer;
        this.readwriteSplittingGroup = this.createStaticReadwriteSplittingGroup(config);
    }

    private StaticReadwriteSplittingGroup createStaticReadwriteSplittingGroup(ReadwriteSplittingDataSourceGroupRuleConfiguration config) {
        return new StaticReadwriteSplittingGroup(config.getWriteDataSourceName(), config.getReadDataSourceNames());
    }

    public String getWriteDataSource() {
        return this.readwriteSplittingGroup.getWriteDataSource();
    }

    public void enableDataSource(String dataSourceName) {
        this.disabledDataSourceNames.remove(dataSourceName);
    }

    public void disableDataSource(String dataSourceName) {
        this.disabledDataSourceNames.add(dataSourceName);
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public TransactionalReadQueryStrategy getTransactionalReadQueryStrategy() {
        return this.transactionalReadQueryStrategy;
    }

    @Generated
    public LoadBalanceAlgorithm getLoadBalancer() {
        return this.loadBalancer;
    }

    @Generated
    public ReadwriteSplittingGroup getReadwriteSplittingGroup() {
        return this.readwriteSplittingGroup;
    }

    @Generated
    public Collection<String> getDisabledDataSourceNames() {
        return this.disabledDataSourceNames;
    }
}

