/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.identifier;

import com.cedarsoftware.util.CaseInsensitiveMap;
import org.apache.shardingsphere.infra.database.core.metadata.database.enums.QuoteCharacter;
import org.apache.shardingsphere.infra.database.core.spi.DatabaseTypedSPILoader;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.metadata.identifier.DatabaseDialectIdentifierHandler;
import org.apache.shardingsphere.sql.parser.statement.core.value.identifier.IdentifierValue;

public final class ShardingSphereIdentifier {
    private final boolean isCaseSensitive;
    private final CaseInsensitiveMap.CaseInsensitiveString value;

    public ShardingSphereIdentifier(String value) {
        this.isCaseSensitive = false;
        this.value = new CaseInsensitiveMap.CaseInsensitiveString(value);
    }

    public ShardingSphereIdentifier(String value, DatabaseType databaseType) {
        this.isCaseSensitive = DatabaseTypedSPILoader.findService(DatabaseDialectIdentifierHandler.class, (DatabaseType)databaseType).map(DatabaseDialectIdentifierHandler::isCaseSensitive).orElse(false);
        this.value = new CaseInsensitiveMap.CaseInsensitiveString(value);
    }

    public ShardingSphereIdentifier(IdentifierValue value) {
        this.isCaseSensitive = QuoteCharacter.NONE != value.getQuoteCharacter();
        this.value = new CaseInsensitiveMap.CaseInsensitiveString(value.getValue());
    }

    public ShardingSphereIdentifier(IdentifierValue value, DatabaseType databaseType) {
        this.isCaseSensitive = QuoteCharacter.NONE != value.getQuoteCharacter() && DatabaseTypedSPILoader.findService(DatabaseDialectIdentifierHandler.class, (DatabaseType)databaseType).map(DatabaseDialectIdentifierHandler::isCaseSensitive).orElse(false) != false;
        this.value = new CaseInsensitiveMap.CaseInsensitiveString(value.getValue());
    }

    public String getValue() {
        return this.value.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ShardingSphereIdentifier)) {
            return false;
        }
        if (null == this.getValue() && null == ((ShardingSphereIdentifier)obj).getValue()) {
            return true;
        }
        return this.isCaseSensitive ? String.valueOf(this.getValue()).equals(((ShardingSphereIdentifier)obj).getValue()) : this.value.equals((Object)((ShardingSphereIdentifier)obj).value);
    }

    public int hashCode() {
        return this.isCaseSensitive ? String.valueOf(this.getValue()).hashCode() : this.value.hashCode();
    }

    public String toString() {
        return this.getValue();
    }
}

