/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mask.rule.changed;

import java.util.LinkedHashMap;
import java.util.LinkedList;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.util.yaml.YamlEngine;
import org.apache.shardingsphere.mask.config.MaskRuleConfiguration;
import org.apache.shardingsphere.mask.config.rule.MaskTableRuleConfiguration;
import org.apache.shardingsphere.mask.rule.MaskRule;
import org.apache.shardingsphere.mask.yaml.config.rule.YamlMaskTableRuleConfiguration;
import org.apache.shardingsphere.mask.yaml.swapper.rule.YamlMaskTableRuleConfigurationSwapper;
import org.apache.shardingsphere.mode.spi.rule.RuleItemConfigurationChangedProcessor;
import org.apache.shardingsphere.mode.spi.rule.item.alter.AlterRuleItem;
import org.apache.shardingsphere.mode.spi.rule.item.drop.DropNamedRuleItem;
import org.apache.shardingsphere.mode.spi.rule.item.drop.DropRuleItem;

public final class MaskTableChangedProcessor
implements RuleItemConfigurationChangedProcessor<MaskRuleConfiguration, MaskTableRuleConfiguration> {
    public MaskTableRuleConfiguration swapRuleItemConfiguration(AlterRuleItem alterRuleItem, String yamlContent) {
        return new YamlMaskTableRuleConfigurationSwapper().swapToObject((YamlMaskTableRuleConfiguration)YamlEngine.unmarshal((String)yamlContent, YamlMaskTableRuleConfiguration.class));
    }

    public MaskRuleConfiguration findRuleConfiguration(ShardingSphereDatabase database) {
        return database.getRuleMetaData().findSingleRule(MaskRule.class).map(MaskRule::getConfiguration).orElseGet(() -> new MaskRuleConfiguration(new LinkedList(), new LinkedHashMap()));
    }

    public void changeRuleItemConfiguration(AlterRuleItem alterRuleItem, MaskRuleConfiguration currentRuleConfig, MaskTableRuleConfiguration toBeChangedItemConfig) {
        currentRuleConfig.getTables().removeIf(each -> each.getName().equals(toBeChangedItemConfig.getName()));
        currentRuleConfig.getTables().add(toBeChangedItemConfig);
    }

    public void dropRuleItemConfiguration(DropRuleItem dropRuleItem, MaskRuleConfiguration currentRuleConfig) {
        currentRuleConfig.getTables().removeIf(each -> each.getName().equals(((DropNamedRuleItem)dropRuleItem).getItemName()));
    }

    public String getType() {
        return "mask.tables";
    }
}

