/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.engine.type;

import lombok.Generated;
import org.apache.shardingsphere.infra.binder.engine.statement.SQLStatementBinderContext;
import org.apache.shardingsphere.infra.binder.engine.statement.dml.CopyStatementBinder;
import org.apache.shardingsphere.infra.binder.engine.statement.dml.DeleteStatementBinder;
import org.apache.shardingsphere.infra.binder.engine.statement.dml.InsertStatementBinder;
import org.apache.shardingsphere.infra.binder.engine.statement.dml.LoadDataStatementBinder;
import org.apache.shardingsphere.infra.binder.engine.statement.dml.LoadXMLStatementBinder;
import org.apache.shardingsphere.infra.binder.engine.statement.dml.SelectStatementBinder;
import org.apache.shardingsphere.infra.binder.engine.statement.dml.UpdateStatementBinder;
import org.apache.shardingsphere.infra.hint.HintValueContext;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.dml.CopyStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.dml.DMLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.dml.DeleteStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.dml.InsertStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.dml.LoadDataStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.dml.LoadXMLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.dml.SelectStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.dml.UpdateStatement;

public final class DMLStatementBindEngine {
    private final ShardingSphereMetaData metaData;
    private final String currentDatabaseName;
    private final HintValueContext hintValueContext;

    public DMLStatement bind(DMLStatement statement) {
        SQLStatementBinderContext binderContext = new SQLStatementBinderContext(this.metaData, this.currentDatabaseName, this.hintValueContext, (SQLStatement)statement);
        if (statement instanceof SelectStatement) {
            return new SelectStatementBinder().bind((SelectStatement)statement, binderContext);
        }
        if (statement instanceof InsertStatement) {
            return new InsertStatementBinder().bind((InsertStatement)statement, binderContext);
        }
        if (statement instanceof UpdateStatement) {
            return new UpdateStatementBinder().bind((UpdateStatement)statement, binderContext);
        }
        if (statement instanceof DeleteStatement) {
            return new DeleteStatementBinder().bind((DeleteStatement)statement, binderContext);
        }
        if (statement instanceof CopyStatement) {
            return new CopyStatementBinder().bind((CopyStatement)statement, binderContext);
        }
        if (statement instanceof LoadDataStatement) {
            return new LoadDataStatementBinder().bind((LoadDataStatement)statement, binderContext);
        }
        if (statement instanceof LoadXMLStatement) {
            return new LoadXMLStatementBinder().bind((LoadXMLStatement)statement, binderContext);
        }
        return statement;
    }

    @Generated
    public DMLStatementBindEngine(ShardingSphereMetaData metaData, String currentDatabaseName, HintValueContext hintValueContext) {
        this.metaData = metaData;
        this.currentDatabaseName = currentDatabaseName;
        this.hintValueContext = hintValueContext;
    }
}

