/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.agent.plugin.core.config.validator;

import lombok.Generated;
import org.apache.shardingsphere.agent.api.PluginConfiguration;
import org.apache.shardingsphere.agent.plugin.core.preconditions.PluginPreconditions;

public final class PluginConfigurationValidator {
    public static void validateHostAndPort(String type, PluginConfiguration pluginConfig) {
        PluginConfigurationValidator.validateHost(type, pluginConfig);
        PluginConfigurationValidator.validatePort(type, pluginConfig);
    }

    public static void validateHost(String type, PluginConfiguration pluginConfig) {
        PluginPreconditions.checkArgument(null != pluginConfig.getHost() && !pluginConfig.getHost().isEmpty(), String.format("Hostname of %s is required.", type));
    }

    public static void validatePort(String type, PluginConfiguration pluginConfig) {
        PluginPreconditions.checkArgument(pluginConfig.getPort() > 0, String.format("Port `%s` of %s must be a positive number.", pluginConfig.getPort(), type));
    }

    @Generated
    private PluginConfigurationValidator() {
    }
}

