/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.globalclock.executor.type;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import org.apache.shardingsphere.globalclock.executor.GlobalClockTransactionExecutor;

public final class OpenGaussGlobalClockTransactionExecutor
implements GlobalClockTransactionExecutor {
    @Override
    public void sendSnapshotTimestamp(Collection<Connection> connections, long globalTimestamp) throws SQLException {
        String sql = String.format("SELECT %d AS SETSNAPSHOTCSN", globalTimestamp);
        for (Connection each : connections) {
            Statement statement = each.createStatement();
            try {
                statement.execute(sql);
            }
            finally {
                if (statement == null) continue;
                statement.close();
            }
        }
    }

    @Override
    public void sendCommitTimestamp(Collection<Connection> connections, long globalTimestamp) throws SQLException {
        String sql = String.format("SELECT %d AS SETCOMMITCSN", globalTimestamp);
        for (Connection each : connections) {
            Statement statement = each.createStatement();
            try {
                statement.execute(sql);
            }
            finally {
                if (statement == null) continue;
                statement.close();
            }
        }
    }

    public String getDatabaseType() {
        return "openGauss";
    }
}

