/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.cluster.persist.service;

import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.shardingsphere.infra.config.rule.RuleConfiguration;
import org.apache.shardingsphere.infra.datasource.pool.destroyer.DataSourcePoolDestroyer;
import org.apache.shardingsphere.infra.datasource.pool.props.domain.DataSourcePoolProperties;
import org.apache.shardingsphere.infra.instance.ComputeNodeInstanceContext;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.database.resource.node.StorageNode;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereTable;
import org.apache.shardingsphere.infra.metadata.database.schema.pojo.AlterSchemaMetaDataPOJO;
import org.apache.shardingsphere.infra.metadata.database.schema.pojo.AlterSchemaPOJO;
import org.apache.shardingsphere.infra.metadata.statistics.ShardingSphereDatabaseData;
import org.apache.shardingsphere.infra.metadata.statistics.ShardingSphereStatistics;
import org.apache.shardingsphere.mode.metadata.MetaDataContextManager;
import org.apache.shardingsphere.mode.metadata.MetaDataContexts;
import org.apache.shardingsphere.mode.metadata.MetaDataContextsFactory;
import org.apache.shardingsphere.mode.metadata.manager.SwitchingResource;
import org.apache.shardingsphere.mode.metadata.persist.MetaDataPersistService;
import org.apache.shardingsphere.mode.metadata.persist.service.config.database.DataSourceUnitPersistService;
import org.apache.shardingsphere.mode.metadata.persist.service.metadata.DatabaseMetaDataPersistFacade;
import org.apache.shardingsphere.mode.persist.service.divided.MetaDataManagerPersistService;
import org.apache.shardingsphere.mode.persist.service.unified.ListenerAssistedPersistService;
import org.apache.shardingsphere.mode.persist.service.unified.ListenerAssistedType;
import org.apache.shardingsphere.mode.spi.repository.PersistRepository;
import org.apache.shardingsphere.single.config.SingleRuleConfiguration;

public final class ClusterMetaDataManagerPersistService
implements MetaDataManagerPersistService {
    private final MetaDataPersistService metaDataPersistService;
    private final ListenerAssistedPersistService listenerAssistedPersistService;
    private final MetaDataContextManager metaDataContextManager;

    public ClusterMetaDataManagerPersistService(PersistRepository repository, MetaDataContextManager metaDataContextManager) {
        this.metaDataPersistService = new MetaDataPersistService(repository);
        this.listenerAssistedPersistService = new ListenerAssistedPersistService(repository);
        this.metaDataContextManager = metaDataContextManager;
    }

    public void createDatabase(String databaseName) {
        this.metaDataPersistService.getDatabaseMetaDataFacade().getDatabase().add(databaseName);
        this.listenerAssistedPersistService.persistDatabaseNameListenerAssisted(databaseName, ListenerAssistedType.CREATE_DATABASE);
    }

    public void dropDatabase(String databaseName) {
        String droppedDatabaseName = this.metaDataContextManager.getMetaDataContexts().getMetaData().getDatabase(databaseName).getName();
        this.listenerAssistedPersistService.persistDatabaseNameListenerAssisted(droppedDatabaseName, ListenerAssistedType.DROP_DATABASE);
        this.metaDataPersistService.getDatabaseMetaDataFacade().getDatabase().drop(droppedDatabaseName);
    }

    public void createSchema(String databaseName, String schemaName) {
        this.metaDataPersistService.getDatabaseMetaDataFacade().getSchema().add(databaseName, schemaName);
    }

    public void alterSchema(AlterSchemaPOJO alterSchemaPOJO) {
        String databaseName = alterSchemaPOJO.getDatabaseName();
        String schemaName = alterSchemaPOJO.getSchemaName();
        ShardingSphereSchema schema = this.metaDataContextManager.getMetaDataContexts().getMetaData().getDatabase(databaseName).getSchema(schemaName);
        if (schema.isEmpty()) {
            this.metaDataPersistService.getDatabaseMetaDataFacade().getSchema().add(databaseName, alterSchemaPOJO.getRenameSchemaName());
        }
        this.metaDataPersistService.getDatabaseMetaDataFacade().getTable().persist(databaseName, alterSchemaPOJO.getRenameSchemaName(), schema.getAllTables());
        this.metaDataPersistService.getDatabaseMetaDataFacade().getView().persist(databaseName, alterSchemaPOJO.getRenameSchemaName(), schema.getAllViews());
        this.metaDataPersistService.getDatabaseMetaDataFacade().getSchema().drop(databaseName, schemaName);
    }

    public void dropSchema(String databaseName, Collection<String> schemaNames) {
        schemaNames.forEach(each -> this.metaDataPersistService.getDatabaseMetaDataFacade().getSchema().drop(databaseName, each));
    }

    public void alterSchemaMetaData(AlterSchemaMetaDataPOJO alterSchemaMetaDataPOJO) {
        String databaseName = alterSchemaMetaDataPOJO.getDatabaseName();
        String schemaName = alterSchemaMetaDataPOJO.getSchemaName();
        DatabaseMetaDataPersistFacade databaseMetaDataFacade = this.metaDataPersistService.getDatabaseMetaDataFacade();
        databaseMetaDataFacade.getTable().persist(databaseName, schemaName, alterSchemaMetaDataPOJO.getAlteredTables());
        databaseMetaDataFacade.getView().persist(databaseName, schemaName, alterSchemaMetaDataPOJO.getAlteredViews());
        alterSchemaMetaDataPOJO.getDroppedTables().forEach(each -> databaseMetaDataFacade.getTable().drop(databaseName, schemaName, each));
        alterSchemaMetaDataPOJO.getDroppedViews().forEach(each -> databaseMetaDataFacade.getView().delete(databaseName, schemaName, each));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerStorageUnits(String databaseName, Map<String, DataSourcePoolProperties> toBeRegisteredProps) {
        MetaDataContexts originalMetaDataContexts = this.buildOriginalMetaDataContexts();
        HashMap<StorageNode, DataSource> newDataSources = new HashMap<StorageNode, DataSource>(toBeRegisteredProps.size());
        try {
            SwitchingResource switchingResource = this.metaDataContextManager.getResourceSwitchManager().switchByRegisterStorageUnit(originalMetaDataContexts.getMetaData().getDatabase(databaseName).getResourceMetaData(), toBeRegisteredProps);
            newDataSources.putAll(switchingResource.getNewDataSources());
            MetaDataContexts reloadMetaDataContexts = MetaDataContextsFactory.createBySwitchResource((String)databaseName, (boolean)false, (SwitchingResource)switchingResource, (MetaDataContexts)originalMetaDataContexts, (MetaDataPersistService)this.metaDataPersistService, (ComputeNodeInstanceContext)this.metaDataContextManager.getComputeNodeInstanceContext());
            this.metaDataPersistService.getDataSourceUnitService().persist(databaseName, toBeRegisteredProps);
            this.afterStorageUnitsAltered(databaseName, originalMetaDataContexts, reloadMetaDataContexts);
            reloadMetaDataContexts.getMetaData().close();
        }
        finally {
            this.closeNewDataSources(newDataSources);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void alterStorageUnits(String databaseName, Map<String, DataSourcePoolProperties> toBeUpdatedProps) throws SQLException {
        MetaDataContexts originalMetaDataContexts = this.buildOriginalMetaDataContexts();
        HashMap<StorageNode, DataSource> newDataSources = new HashMap<StorageNode, DataSource>(toBeUpdatedProps.size());
        try {
            SwitchingResource switchingResource = this.metaDataContextManager.getResourceSwitchManager().switchByAlterStorageUnit(originalMetaDataContexts.getMetaData().getDatabase(databaseName).getResourceMetaData(), toBeUpdatedProps);
            newDataSources.putAll(switchingResource.getNewDataSources());
            MetaDataContexts reloadMetaDataContexts = MetaDataContextsFactory.createBySwitchResource((String)databaseName, (boolean)false, (SwitchingResource)switchingResource, (MetaDataContexts)originalMetaDataContexts, (MetaDataPersistService)this.metaDataPersistService, (ComputeNodeInstanceContext)this.metaDataContextManager.getComputeNodeInstanceContext());
            DataSourceUnitPersistService dataSourceService = this.metaDataPersistService.getDataSourceUnitService();
            this.metaDataPersistService.getMetaDataVersionPersistService().switchActiveVersion(dataSourceService.persist(databaseName, toBeUpdatedProps));
            this.afterStorageUnitsAltered(databaseName, originalMetaDataContexts, reloadMetaDataContexts);
            reloadMetaDataContexts.getMetaData().close();
        }
        finally {
            this.closeNewDataSources(newDataSources);
        }
    }

    public void unregisterStorageUnits(String databaseName, Collection<String> toBeDroppedStorageUnitNames) throws SQLException {
        for (String each : this.getToBeDroppedResourceNames(databaseName, toBeDroppedStorageUnitNames)) {
            MetaDataContexts originalMetaDataContexts = this.buildOriginalMetaDataContexts();
            SwitchingResource switchingResource = this.metaDataContextManager.getResourceSwitchManager().createByUnregisterStorageUnit(originalMetaDataContexts.getMetaData().getDatabase(databaseName).getResourceMetaData(), Collections.singletonList(each));
            MetaDataContexts reloadMetaDataContexts = MetaDataContextsFactory.createBySwitchResource((String)databaseName, (boolean)false, (SwitchingResource)switchingResource, (MetaDataContexts)originalMetaDataContexts, (MetaDataPersistService)this.metaDataPersistService, (ComputeNodeInstanceContext)this.metaDataContextManager.getComputeNodeInstanceContext());
            this.metaDataPersistService.getDataSourceUnitService().delete(databaseName, each);
            this.afterStorageUnitsDropped(databaseName, originalMetaDataContexts, reloadMetaDataContexts);
            reloadMetaDataContexts.getMetaData().close();
        }
    }

    private void closeNewDataSources(Map<StorageNode, DataSource> newDataSources) {
        for (Map.Entry<StorageNode, DataSource> entry : newDataSources.entrySet()) {
            if (null == entry.getValue()) continue;
            new DataSourcePoolDestroyer(entry.getValue()).asyncDestroy();
        }
    }

    private Collection<String> getToBeDroppedResourceNames(String databaseName, Collection<String> toBeDroppedResourceNames) {
        Map propsMap = this.metaDataPersistService.getDataSourceUnitService().load(databaseName);
        return toBeDroppedResourceNames.stream().filter(propsMap::containsKey).collect(Collectors.toList());
    }

    private void afterStorageUnitsAltered(String databaseName, MetaDataContexts originalMetaDataContexts, MetaDataContexts reloadMetaDataContexts) {
        Optional.ofNullable((ShardingSphereDatabaseData)reloadMetaDataContexts.getStatistics().getDatabaseData().get(databaseName)).ifPresent(optional -> optional.getSchemaData().forEach((schemaName, schemaData) -> this.metaDataPersistService.getShardingSphereDataPersistService().persist(originalMetaDataContexts.getMetaData().getDatabase(databaseName), schemaName, schemaData)));
        this.metaDataPersistService.persistReloadDatabaseByAlter(databaseName, reloadMetaDataContexts.getMetaData().getDatabase(databaseName), originalMetaDataContexts.getMetaData().getDatabase(databaseName));
    }

    private void afterStorageUnitsDropped(String databaseName, MetaDataContexts originalMetaDataContexts, MetaDataContexts reloadMetaDataContexts) {
        reloadMetaDataContexts.getMetaData().getDatabase(databaseName).getAllSchemas().forEach(each -> this.metaDataPersistService.getDatabaseMetaDataFacade().getSchema().alterByRuleDropped(reloadMetaDataContexts.getMetaData().getDatabase(databaseName).getName(), each));
        Optional.ofNullable((ShardingSphereDatabaseData)reloadMetaDataContexts.getStatistics().getDatabaseData().get(databaseName)).ifPresent(optional -> optional.getSchemaData().forEach((schemaName, schemaData) -> this.metaDataPersistService.getShardingSphereDataPersistService().persist(originalMetaDataContexts.getMetaData().getDatabase(databaseName), schemaName, schemaData)));
        this.metaDataPersistService.persistReloadDatabaseByDrop(databaseName, reloadMetaDataContexts.getMetaData().getDatabase(databaseName), originalMetaDataContexts.getMetaData().getDatabase(databaseName));
    }

    public void alterSingleRuleConfiguration(String databaseName, Collection<RuleConfiguration> ruleConfigs) {
        ruleConfigs.removeIf(each -> !each.getClass().isAssignableFrom(SingleRuleConfiguration.class));
        this.metaDataPersistService.getMetaDataVersionPersistService().switchActiveVersion(this.metaDataPersistService.getDatabaseRulePersistService().persist(databaseName, ruleConfigs));
    }

    public void alterRuleConfiguration(String databaseName, RuleConfiguration toBeAlteredRuleConfig) {
        if (null == toBeAlteredRuleConfig) {
            return;
        }
        MetaDataContexts originalMetaDataContexts = this.buildOriginalMetaDataContexts();
        Collection metaDataVersions = this.metaDataPersistService.getDatabaseRulePersistService().persist(databaseName, Collections.singleton(toBeAlteredRuleConfig));
        this.metaDataPersistService.getMetaDataVersionPersistService().switchActiveVersion(metaDataVersions);
        this.afterRuleConfigurationAltered(databaseName, originalMetaDataContexts);
    }

    private void afterRuleConfigurationAltered(String databaseName, MetaDataContexts originalMetaDataContexts) {
        Thread.sleep(3000L);
        MetaDataContexts reloadMetaDataContexts = this.metaDataContextManager.getMetaDataContexts();
        this.metaDataPersistService.persistReloadDatabaseByAlter(databaseName, reloadMetaDataContexts.getMetaData().getDatabase(databaseName), originalMetaDataContexts.getMetaData().getDatabase(databaseName));
    }

    public void removeRuleConfigurationItem(String databaseName, RuleConfiguration toBeRemovedRuleConfig) {
        if (null != toBeRemovedRuleConfig) {
            this.metaDataPersistService.getDatabaseRulePersistService().delete(databaseName, Collections.singleton(toBeRemovedRuleConfig));
        }
    }

    public void removeRuleConfiguration(String databaseName, String ruleName) {
        MetaDataContexts originalMetaDataContexts = this.buildOriginalMetaDataContexts();
        this.metaDataPersistService.getDatabaseRulePersistService().delete(databaseName, ruleName);
        this.afterRuleConfigurationDropped(databaseName, originalMetaDataContexts);
    }

    private void afterRuleConfigurationDropped(String databaseName, MetaDataContexts originalMetaDataContexts) {
        Thread.sleep(3000L);
        MetaDataContexts reloadMetaDataContexts = this.metaDataContextManager.getMetaDataContexts();
        this.metaDataPersistService.persistReloadDatabaseByDrop(databaseName, reloadMetaDataContexts.getMetaData().getDatabase(databaseName), originalMetaDataContexts.getMetaData().getDatabase(databaseName));
    }

    public void alterGlobalRuleConfiguration(RuleConfiguration toBeAlteredRuleConfig) {
        this.metaDataPersistService.getGlobalRuleService().persist(Collections.singleton(toBeAlteredRuleConfig));
    }

    public void alterProperties(Properties props) {
        this.metaDataPersistService.getPropsService().persist(props);
    }

    public void createTable(String databaseName, String schemaName, ShardingSphereTable table, String logicDataSourceName) {
        this.metaDataPersistService.getDatabaseMetaDataFacade().getTable().persist(databaseName, schemaName, Collections.singleton(table));
    }

    public void dropTables(String databaseName, String schemaName, Collection<String> tableNames) {
        tableNames.forEach(each -> this.metaDataPersistService.getDatabaseMetaDataFacade().getTable().drop(databaseName, schemaName, each));
    }

    private MetaDataContexts buildOriginalMetaDataContexts() {
        ShardingSphereMetaData originalMetaData = this.metaDataContextManager.getMetaDataContexts().getMetaData();
        ShardingSphereStatistics originalStatistics = this.metaDataContextManager.getMetaDataContexts().getStatistics();
        return new MetaDataContexts(originalMetaData, originalStatistics);
    }
}

