/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.cdc.distsql.parser.core;

import java.util.Properties;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.shardingsphere.data.pipeline.cdc.distsql.statement.queryable.ShowStreamingListStatement;
import org.apache.shardingsphere.data.pipeline.cdc.distsql.statement.queryable.ShowStreamingRuleStatement;
import org.apache.shardingsphere.data.pipeline.cdc.distsql.statement.queryable.ShowStreamingStatusStatement;
import org.apache.shardingsphere.data.pipeline.cdc.distsql.statement.updatable.DropStreamingStatement;
import org.apache.shardingsphere.data.pipeline.distsql.statement.updatable.AlterTransmissionRuleStatement;
import org.apache.shardingsphere.distsql.parser.autogen.CDCDistSQLStatementBaseVisitor;
import org.apache.shardingsphere.distsql.parser.autogen.CDCDistSQLStatementParser;
import org.apache.shardingsphere.distsql.segment.AlgorithmSegment;
import org.apache.shardingsphere.distsql.segment.ReadOrWriteSegment;
import org.apache.shardingsphere.distsql.segment.TransmissionRuleSegment;
import org.apache.shardingsphere.infra.database.core.metadata.database.enums.QuoteCharacter;
import org.apache.shardingsphere.sql.parser.api.ASTNode;
import org.apache.shardingsphere.sql.parser.api.visitor.SQLVisitor;
import org.apache.shardingsphere.sql.parser.statement.core.value.identifier.IdentifierValue;

public final class CDCDistSQLStatementVisitor
extends CDCDistSQLStatementBaseVisitor<ASTNode>
implements SQLVisitor<ASTNode> {
    @Override
    public ASTNode visitShowStreamingList(CDCDistSQLStatementParser.ShowStreamingListContext ctx) {
        return new ShowStreamingListStatement();
    }

    @Override
    public ASTNode visitShowStreamingStatus(CDCDistSQLStatementParser.ShowStreamingStatusContext ctx) {
        return new ShowStreamingStatusStatement(this.getIdentifierValue((ParseTree)ctx.jobId()));
    }

    @Override
    public ASTNode visitDropStreaming(CDCDistSQLStatementParser.DropStreamingContext ctx) {
        return new DropStreamingStatement(this.getIdentifierValue((ParseTree)ctx.jobId()));
    }

    private String getIdentifierValue(ParseTree ctx) {
        return null == ctx ? null : new IdentifierValue(ctx.getText()).getValue();
    }

    @Override
    public ASTNode visitShowStreamingRule(CDCDistSQLStatementParser.ShowStreamingRuleContext ctx) {
        return new ShowStreamingRuleStatement();
    }

    @Override
    public ASTNode visitAlterStreamingRule(CDCDistSQLStatementParser.AlterStreamingRuleContext ctx) {
        return new AlterTransmissionRuleStatement("STREAMING", (TransmissionRuleSegment)this.visit((ParseTree)ctx.transmissionRule()));
    }

    @Override
    public ASTNode visitTransmissionRule(CDCDistSQLStatementParser.TransmissionRuleContext ctx) {
        TransmissionRuleSegment result = new TransmissionRuleSegment();
        if (null != ctx.readDefinition()) {
            result.setReadSegment((ReadOrWriteSegment)this.visit((ParseTree)ctx.readDefinition()));
        }
        if (null != ctx.writeDefinition()) {
            result.setWriteSegment((ReadOrWriteSegment)this.visit((ParseTree)ctx.writeDefinition()));
        }
        if (null != ctx.streamChannel()) {
            result.setStreamChannel((AlgorithmSegment)this.visit((ParseTree)ctx.streamChannel()));
        }
        return result;
    }

    @Override
    public ASTNode visitReadDefinition(CDCDistSQLStatementParser.ReadDefinitionContext ctx) {
        return new ReadOrWriteSegment(this.getWorkerThread(ctx.workerThread()), this.getBatchSize(ctx.batchSize()), this.getShardingSize(ctx.shardingSize()), this.getAlgorithmSegment(ctx.rateLimiter()));
    }

    private Integer getWorkerThread(CDCDistSQLStatementParser.WorkerThreadContext ctx) {
        return null == ctx ? null : Integer.valueOf(Integer.parseInt(ctx.intValue().getText()));
    }

    private Integer getBatchSize(CDCDistSQLStatementParser.BatchSizeContext ctx) {
        return null == ctx ? null : Integer.valueOf(Integer.parseInt(ctx.intValue().getText()));
    }

    private Integer getShardingSize(CDCDistSQLStatementParser.ShardingSizeContext ctx) {
        return null == ctx ? null : Integer.valueOf(Integer.parseInt(ctx.intValue().getText()));
    }

    private AlgorithmSegment getAlgorithmSegment(CDCDistSQLStatementParser.RateLimiterContext ctx) {
        return null == ctx ? null : (AlgorithmSegment)this.visit((ParseTree)ctx);
    }

    @Override
    public ASTNode visitWriteDefinition(CDCDistSQLStatementParser.WriteDefinitionContext ctx) {
        return new ReadOrWriteSegment(this.getWorkerThread(ctx.workerThread()), this.getBatchSize(ctx.batchSize()), this.getAlgorithmSegment(ctx.rateLimiter()));
    }

    @Override
    public ASTNode visitRateLimiter(CDCDistSQLStatementParser.RateLimiterContext ctx) {
        return (ASTNode)this.visit((ParseTree)ctx.algorithmDefinition());
    }

    @Override
    public ASTNode visitStreamChannel(CDCDistSQLStatementParser.StreamChannelContext ctx) {
        return (ASTNode)this.visit((ParseTree)ctx.algorithmDefinition());
    }

    @Override
    public ASTNode visitAlgorithmDefinition(CDCDistSQLStatementParser.AlgorithmDefinitionContext ctx) {
        return new AlgorithmSegment(this.getIdentifierValue((ParseTree)ctx.algorithmTypeName()), this.buildProperties(ctx.propertiesDefinition()));
    }

    private Properties buildProperties(CDCDistSQLStatementParser.PropertiesDefinitionContext ctx) {
        Properties result = new Properties();
        if (null == ctx) {
            return result;
        }
        for (CDCDistSQLStatementParser.PropertyContext each : ctx.properties().property()) {
            result.setProperty(QuoteCharacter.unwrapAndTrimText((String)each.key.getText()), QuoteCharacter.unwrapAndTrimText((String)each.value.getText()));
        }
        return result;
    }
}

