/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.extended.bind.protocol.util;

import java.sql.Timestamp;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import lombok.Generated;

public final class PostgreSQLBinaryTimestampUtils {
    private static final Long POSTGRESQL_SECONDS_OFFSET = 946684800L;
    private static final Long JULIAN_GREGORIAN_CALENDAR_CUTOFF_POINT = -13165977600L;

    public static long toPostgreSQLTime(Timestamp timestamp) {
        long millis = timestamp.getTime() - (long)timestamp.getNanos() / 1000000L + (long)TimeZone.getDefault().getRawOffset();
        long nanos = (long)timestamp.getNanos() / 1000L;
        long pgSeconds = PostgreSQLBinaryTimestampUtils.convertJavaEpochToPgEpoch(millis / 1000L);
        if (nanos >= 1000000L) {
            nanos -= 1000000L;
            ++pgSeconds;
        }
        return pgSeconds * 1000000L + nanos;
    }

    private static long convertJavaEpochToPgEpoch(long seconds) {
        long result = seconds - POSTGRESQL_SECONDS_OFFSET;
        if (result >= JULIAN_GREGORIAN_CALENDAR_CUTOFF_POINT) {
            return result;
        }
        if ((result = PostgreSQLBinaryTimestampUtils.convertToJulianSeconds(result)) < -15773356800L) {
            int years = (int)((result + 15773356800L) / -3155823050L);
            ++years;
            years -= years / 4;
            result += (long)years * 86400L;
        }
        return result;
    }

    private static long convertToJulianSeconds(long seconds) {
        return seconds - TimeUnit.DAYS.toSeconds(10L);
    }

    @Generated
    private PostgreSQLBinaryTimestampUtils() {
    }
}

