/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.registrycenter.repository.job;

import com.google.common.base.Strings;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.core.consistencycheck.result.TableDataConsistencyCheckResult;
import org.apache.shardingsphere.data.pipeline.core.consistencycheck.result.yaml.YamlTableDataConsistencyCheckResult;
import org.apache.shardingsphere.data.pipeline.core.consistencycheck.result.yaml.YamlTableDataConsistencyCheckResultSwapper;
import org.apache.shardingsphere.data.pipeline.core.exception.job.ConsistencyCheckJobNotFoundException;
import org.apache.shardingsphere.data.pipeline.core.metadata.node.PipelineMetaDataNode;
import org.apache.shardingsphere.infra.util.yaml.YamlEngine;
import org.apache.shardingsphere.mode.repository.cluster.ClusterPersistRepository;

public final class PipelineJobCheckGovernanceRepository {
    private final ClusterPersistRepository repository;

    public Optional<String> findLatestCheckJobId(String parentJobId) {
        return Optional.ofNullable(this.repository.query(PipelineMetaDataNode.getLatestCheckJobIdPath(parentJobId)));
    }

    public String getLatestCheckJobId(String parentJobId) {
        return this.findLatestCheckJobId(parentJobId).orElseThrow(() -> new ConsistencyCheckJobNotFoundException(parentJobId));
    }

    public void persistLatestCheckJobId(String parentJobId, String checkJobId) {
        this.repository.persist(PipelineMetaDataNode.getLatestCheckJobIdPath(parentJobId), String.valueOf(checkJobId));
    }

    public void deleteLatestCheckJobId(String parentJobId) {
        this.repository.delete(PipelineMetaDataNode.getLatestCheckJobIdPath(parentJobId));
    }

    public Map<String, TableDataConsistencyCheckResult> getCheckJobResult(String parentJobId, String checkJobId) {
        String yamlCheckResultMapText = this.repository.query(PipelineMetaDataNode.getCheckJobResultPath(parentJobId, checkJobId));
        if (Strings.isNullOrEmpty((String)yamlCheckResultMapText)) {
            return Collections.emptyMap();
        }
        YamlTableDataConsistencyCheckResultSwapper swapper = new YamlTableDataConsistencyCheckResultSwapper();
        Map yamlCheckResultMap = (Map)YamlEngine.unmarshal((String)yamlCheckResultMapText, Map.class, (boolean)true);
        HashMap<String, TableDataConsistencyCheckResult> result = new HashMap<String, TableDataConsistencyCheckResult>(yamlCheckResultMap.size(), 1.0f);
        for (Map.Entry entry : yamlCheckResultMap.entrySet()) {
            result.put((String)entry.getKey(), swapper.swapToObject((String)entry.getValue()));
        }
        return result;
    }

    public void initCheckJobResult(String parentJobId, String checkJobId) {
        this.repository.persist(PipelineMetaDataNode.getCheckJobResultPath(parentJobId, checkJobId), "");
    }

    public void persistCheckJobResult(String parentJobId, String checkJobId, Map<String, TableDataConsistencyCheckResult> checkResultMap) {
        if (null == checkResultMap) {
            return;
        }
        LinkedHashMap<String, String> yamlCheckResultMap = new LinkedHashMap<String, String>(checkResultMap.size(), 1.0f);
        for (Map.Entry<String, TableDataConsistencyCheckResult> entry : checkResultMap.entrySet()) {
            YamlTableDataConsistencyCheckResult yamlCheckResult = new YamlTableDataConsistencyCheckResultSwapper().swapToYamlConfiguration(entry.getValue());
            yamlCheckResultMap.put(entry.getKey(), YamlEngine.marshal((Object)yamlCheckResult));
        }
        this.repository.persist(PipelineMetaDataNode.getCheckJobResultPath(parentJobId, checkJobId), YamlEngine.marshal(yamlCheckResultMap));
    }

    public void deleteCheckJobResult(String parentJobId, String checkJobId) {
        this.repository.delete(PipelineMetaDataNode.getCheckJobResultPath(parentJobId, checkJobId));
    }

    public Collection<String> listCheckJobIds(String parentJobId) {
        return this.repository.getChildrenKeys(PipelineMetaDataNode.getCheckJobIdsRootPath(parentJobId));
    }

    @Generated
    public PipelineJobCheckGovernanceRepository(ClusterPersistRepository repository) {
        this.repository = repository;
    }
}

