/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.metadata;

import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.database.core.metadata.database.DialectDatabaseMetaData;
import org.apache.shardingsphere.infra.database.core.spi.DatabaseTypedSPILoader;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.database.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.statistics.ShardingSphereDatabaseData;
import org.apache.shardingsphere.infra.metadata.statistics.ShardingSphereStatistics;
import org.apache.shardingsphere.infra.metadata.statistics.builder.ShardingSphereStatisticsBuilder;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;
import org.apache.shardingsphere.mode.metadata.persist.MetaDataPersistService;

public final class ShardingSphereStatisticsFactory {
    public static ShardingSphereStatistics create(MetaDataPersistService persistService, ShardingSphereMetaData metaData) {
        if (metaData.getAllDatabases().isEmpty()) {
            return new ShardingSphereStatistics();
        }
        Optional statisticsBuilder = DatabaseTypedSPILoader.findService(ShardingSphereStatisticsBuilder.class, (DatabaseType)ShardingSphereStatisticsFactory.getDatabaseType(metaData));
        if (!statisticsBuilder.isPresent()) {
            return new ShardingSphereStatistics();
        }
        ShardingSphereStatistics builtStatistics = ShardingSphereStatisticsFactory.build(metaData, (ShardingSphereStatisticsBuilder)statisticsBuilder.get());
        Optional<ShardingSphereStatistics> loadedStatistics = persistService.getShardingSphereDataPersistService().load(metaData);
        if (!loadedStatistics.isPresent()) {
            return builtStatistics;
        }
        ShardingSphereStatisticsFactory.putStatisticsIfAbsent(loadedStatistics.get(), builtStatistics);
        return loadedStatistics.get();
    }

    private static DatabaseType getDatabaseType(ShardingSphereMetaData metaData) {
        DatabaseType protocolType = ((ShardingSphereDatabase)metaData.getAllDatabases().iterator().next()).getProtocolType();
        DialectDatabaseMetaData dialectDatabaseMetaData = new DatabaseTypeRegistry(protocolType).getDialectDatabaseMetaData();
        return dialectDatabaseMetaData.getDefaultSchema().isPresent() ? (DatabaseType)TypedSPILoader.getService(DatabaseType.class, (Object)"PostgreSQL") : protocolType;
    }

    private static ShardingSphereStatistics build(ShardingSphereMetaData metaData, ShardingSphereStatisticsBuilder statisticsBuilder) {
        ShardingSphereStatistics result = new ShardingSphereStatistics();
        for (ShardingSphereDatabase each : metaData.getAllDatabases()) {
            ShardingSphereDatabaseData databaseData = statisticsBuilder.build(each);
            if (databaseData.getSchemaData().isEmpty()) continue;
            result.putDatabase(each.getName(), databaseData);
        }
        return result;
    }

    private static void putStatisticsIfAbsent(ShardingSphereStatistics loadedStatistics, ShardingSphereStatistics builtStatistics) {
        loadedStatistics.getDatabaseData().keySet().stream().filter(arg_0 -> ((ShardingSphereStatistics)builtStatistics).containsDatabase(arg_0)).forEach(arg_0 -> ((ShardingSphereStatistics)builtStatistics).dropDatabase(arg_0));
        builtStatistics.getDatabaseData().forEach((arg_0, arg_1) -> ((ShardingSphereStatistics)loadedStatistics).putDatabase(arg_0, arg_1));
    }

    @Generated
    private ShardingSphereStatisticsFactory() {
    }
}

