/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.lite.api.registry;

import java.util.Arrays;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import lombok.Generated;
import org.apache.curator.utils.ThreadUtils;
import org.apache.shardingsphere.elasticjob.api.ElasticJob;
import org.apache.shardingsphere.elasticjob.api.JobConfiguration;
import org.apache.shardingsphere.elasticjob.infra.handler.sharding.JobInstance;
import org.apache.shardingsphere.elasticjob.infra.pojo.JobConfigurationPOJO;
import org.apache.shardingsphere.elasticjob.infra.yaml.YamlEngine;
import org.apache.shardingsphere.elasticjob.lite.api.bootstrap.impl.OneOffJobBootstrap;
import org.apache.shardingsphere.elasticjob.lite.api.bootstrap.impl.ScheduleJobBootstrap;
import org.apache.shardingsphere.elasticjob.lite.internal.storage.JobNodePath;
import org.apache.shardingsphere.elasticjob.reg.base.CoordinatorRegistryCenter;
import org.apache.shardingsphere.elasticjob.reg.listener.DataChangedEvent;
import org.apache.shardingsphere.elasticjob.reg.listener.DataChangedEventListener;

public final class JobInstanceRegistry {
    private static final Pattern JOB_CONFIG_COMPILE = Pattern.compile("/(\\w+)/config");
    private final CoordinatorRegistryCenter regCenter;
    private final JobInstance jobInstance;

    public void register() {
        ThreadFactory threadFactory = ThreadUtils.newGenericThreadFactory((String)"ListenerNotify-instanceRegistry");
        ExecutorService executor = Executors.newSingleThreadExecutor(threadFactory);
        this.regCenter.watch("/", (DataChangedEventListener)new JobInstanceRegistryListener(), (Executor)executor);
    }

    @Generated
    public JobInstanceRegistry(CoordinatorRegistryCenter regCenter, JobInstance jobInstance) {
        this.regCenter = regCenter;
        this.jobInstance = jobInstance;
    }

    public class JobInstanceRegistryListener
    implements DataChangedEventListener {
        public void onChange(DataChangedEvent event) {
            if (event.getType() != DataChangedEvent.Type.ADDED || !this.isJobConfigPath(event.getKey())) {
                return;
            }
            JobConfiguration jobConfig = ((JobConfigurationPOJO)YamlEngine.unmarshal((String)event.getValue(), JobConfigurationPOJO.class)).toJobConfiguration();
            if (jobConfig.isDisabled() || !this.isLabelMatch(jobConfig)) {
                return;
            }
            if (!jobConfig.getCron().isEmpty()) {
                new ScheduleJobBootstrap(JobInstanceRegistry.this.regCenter, this.newElasticJobInstance(jobConfig), jobConfig).schedule();
            } else if (!this.isAllShardingItemsCompleted(jobConfig)) {
                new OneOffJobBootstrap(JobInstanceRegistry.this.regCenter, this.newElasticJobInstance(jobConfig), jobConfig).execute();
            }
        }

        private boolean isAllShardingItemsCompleted(JobConfiguration jobConfig) {
            JobNodePath jobNodePath = new JobNodePath(jobConfig.getJobName());
            return IntStream.range(0, jobConfig.getShardingTotalCount()).allMatch(each -> JobInstanceRegistry.this.regCenter.isExisted(jobNodePath.getShardingNodePath(String.valueOf(each), "completed")));
        }

        private ElasticJob newElasticJobInstance(JobConfiguration jobConfig) {
            String clazz = JobInstanceRegistry.this.regCenter.get(String.format("/%s", jobConfig.getJobName()));
            try {
                return (ElasticJob)Class.forName(clazz).newInstance();
            }
            catch (Exception ex) {
                throw new RuntimeException(String.format("new elastic job instance by class '%s' failure", clazz), ex);
            }
        }

        private boolean isLabelMatch(JobConfiguration jobConfig) {
            if (jobConfig.getLabel() == null) {
                return false;
            }
            if (JobInstanceRegistry.this.jobInstance.getLabels() == null) {
                return true;
            }
            return Arrays.stream(JobInstanceRegistry.this.jobInstance.getLabels().split(",")).collect(Collectors.toSet()).contains(jobConfig.getLabel());
        }

        private boolean isJobConfigPath(String path) {
            return JOB_CONFIG_COMPILE.matcher(path).matches();
        }
    }
}

