/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.lite.internal.reconcile;

import com.google.common.util.concurrent.AbstractScheduledService;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.shardingsphere.elasticjob.lite.internal.config.ConfigurationService;
import org.apache.shardingsphere.elasticjob.lite.internal.sharding.ShardingService;
import org.apache.shardingsphere.elasticjob.lite.internal.storage.JobNodePath;
import org.apache.shardingsphere.elasticjob.reg.base.CoordinatorRegistryCenter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ReconcileService
extends AbstractScheduledService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ReconcileService.class);
    private long lastReconcileTime;
    private final ConfigurationService configService;
    private final ShardingService shardingService;
    private final JobNodePath jobNodePath;
    private final CoordinatorRegistryCenter regCenter;

    public ReconcileService(CoordinatorRegistryCenter regCenter, String jobName) {
        this.regCenter = regCenter;
        this.lastReconcileTime = System.currentTimeMillis();
        this.configService = new ConfigurationService(regCenter, jobName);
        this.shardingService = new ShardingService(regCenter, jobName);
        this.jobNodePath = new JobNodePath(jobName);
    }

    protected void runOneIteration() {
        int reconcileIntervalMinutes = this.configService.load(true).getReconcileIntervalMinutes();
        if (reconcileIntervalMinutes > 0 && System.currentTimeMillis() - this.lastReconcileTime >= (long)reconcileIntervalMinutes * 60L * 1000L) {
            this.lastReconcileTime = System.currentTimeMillis();
            if (!(this.shardingService.isNeedSharding() || !this.shardingService.hasShardingInfoInOfflineServers() || this.isStaticSharding() && this.hasShardingInfo())) {
                log.warn("Elastic Job: job status node has inconsistent value,start reconciling...");
                this.shardingService.setReshardingFlag();
            }
        }
    }

    private boolean isStaticSharding() {
        return this.configService.load(true).isStaticSharding();
    }

    private boolean hasShardingInfo() {
        return !this.regCenter.getChildrenKeys(this.jobNodePath.getShardingNodePath()).isEmpty();
    }

    protected AbstractScheduledService.Scheduler scheduler() {
        return AbstractScheduledService.Scheduler.newFixedDelaySchedule((long)0L, (long)1L, (TimeUnit)TimeUnit.MINUTES);
    }
}

