/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.handler.distsql;

import lombok.Generated;
import org.apache.shardingsphere.distsql.statement.DistSQLStatement;
import org.apache.shardingsphere.distsql.statement.ral.RALStatement;
import org.apache.shardingsphere.distsql.statement.ral.queryable.QueryableRALStatement;
import org.apache.shardingsphere.distsql.statement.rdl.RDLStatement;
import org.apache.shardingsphere.distsql.statement.rql.RQLStatement;
import org.apache.shardingsphere.distsql.statement.rul.RULStatement;
import org.apache.shardingsphere.infra.exception.generic.UnsupportedSQLOperationException;
import org.apache.shardingsphere.proxy.backend.handler.ProxyBackendHandler;
import org.apache.shardingsphere.proxy.backend.handler.distsql.DistSQLQueryBackendHandler;
import org.apache.shardingsphere.proxy.backend.handler.distsql.DistSQLUpdateBackendHandler;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;

public final class DistSQLBackendHandlerFactory {
    public static ProxyBackendHandler newInstance(DistSQLStatement sqlStatement, ConnectionSession connectionSession) {
        if (sqlStatement instanceof RQLStatement || sqlStatement instanceof RULStatement) {
            return new DistSQLQueryBackendHandler(sqlStatement, connectionSession);
        }
        if (sqlStatement instanceof RDLStatement) {
            return new DistSQLUpdateBackendHandler(sqlStatement, connectionSession);
        }
        if (sqlStatement instanceof RALStatement) {
            return sqlStatement instanceof QueryableRALStatement ? new DistSQLQueryBackendHandler(sqlStatement, connectionSession) : new DistSQLUpdateBackendHandler(sqlStatement, connectionSession);
        }
        throw new UnsupportedSQLOperationException(sqlStatement.getClass().getName());
    }

    @Generated
    private DistSQLBackendHandlerFactory() {
    }
}

