/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.datasource.xa;

import java.io.Serializable;
import javax.transaction.xa.Xid;

public class XID
implements Serializable,
Xid {
    private static final long serialVersionUID = 4796496938014754464L;
    private static final int DEFAULT_FORMAT = 1096044365;
    private String cachedToStringForPerformance;
    private final int formatId;
    private final byte[] branchQualifier;
    private final byte[] globalTransactionId;
    private final String branchQualifierStr;
    private final String globalTransactionIdStr;
    private final String uniqueResourceName;
    private static final byte[] HEX_CHAR_TABLE = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};

    public XID(String tid, String branchQualifier, String uniqueResourceName) {
        this.formatId = 1096044365;
        this.uniqueResourceName = uniqueResourceName;
        this.globalTransactionIdStr = tid;
        this.globalTransactionId = tid.toString().getBytes();
        if (this.globalTransactionId.length > 64) {
            throw new RuntimeException("Max global tid length exceeded.");
        }
        this.branchQualifierStr = branchQualifier;
        this.branchQualifier = branchQualifier.getBytes();
        if (this.branchQualifier.length > 64) {
            throw new RuntimeException("Max branch qualifier length exceeded.");
        }
    }

    public XID(Xid xid) {
        this.formatId = xid.getFormatId();
        this.globalTransactionId = xid.getGlobalTransactionId();
        this.branchQualifier = xid.getBranchQualifier();
        this.globalTransactionIdStr = new String(xid.getGlobalTransactionId());
        this.branchQualifierStr = new String(xid.getBranchQualifier());
        this.uniqueResourceName = null;
    }

    @Override
    public int getFormatId() {
        return this.formatId;
    }

    @Override
    public byte[] getBranchQualifier() {
        return this.branchQualifier;
    }

    @Override
    public byte[] getGlobalTransactionId() {
        return this.globalTransactionId;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof XID) {
            XID xid = (XID)obj;
            return this.toString().equals(xid.toString());
        }
        return false;
    }

    public String toString() {
        if (this.cachedToStringForPerformance == null) {
            String gtrid = XID.byteArrayToHexString(this.getGlobalTransactionId());
            String bqual = XID.byteArrayToHexString(this.getBranchQualifier());
            this.cachedToStringForPerformance = "XID: " + gtrid + ":" + bqual;
        }
        return this.cachedToStringForPerformance;
    }

    private static String byteArrayToHexString(byte[] raw) {
        byte[] hex = new byte[2 * raw.length];
        int index = 0;
        for (byte b : raw) {
            int v = b & 0xFF;
            hex[index++] = HEX_CHAR_TABLE[v >>> 4];
            hex[index++] = HEX_CHAR_TABLE[v & 0xF];
        }
        return new String(hex);
    }

    public String getBranchQualifierAsString() {
        return this.branchQualifierStr;
    }

    public String getGlobalTransactionIdAsString() {
        return this.globalTransactionIdStr;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String getUniqueResourceName() {
        return this.uniqueResourceName;
    }
}

