/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.recovery.xa;

import com.atomikos.datasource.xa.XID;
import com.atomikos.recovery.xa.PreviousXidRepository;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class InMemoryPreviousXidRepository
implements PreviousXidRepository {
    private Map<Long, List<XID>> cache = new HashMap<Long, List<XID>>();

    @Override
    public synchronized List<XID> findXidsExpiredAt(long startOfRecoveryScan) {
        ArrayList<XID> xids = new ArrayList<XID>();
        for (Long expiration : this.cache.keySet()) {
            if (expiration >= startOfRecoveryScan) continue;
            xids.addAll((Collection<XID>)this.cache.get(expiration));
        }
        return xids;
    }

    @Override
    public synchronized void forgetXidsExpiredAt(long startOfRecoveryScan) {
        Iterator<Long> it = this.cache.keySet().iterator();
        while (it.hasNext()) {
            Long expiration = it.next();
            if (expiration > startOfRecoveryScan) continue;
            it.remove();
        }
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.cache.isEmpty();
    }

    @Override
    public synchronized void remember(XID xidToStoreForNextScan, long expiration) {
        List<XID> xids = this.cache.get(expiration);
        if (xids == null) {
            xids = new ArrayList<XID>();
        }
        xids.add(xidToStoreForNextScan);
        this.cache.put(expiration, xids);
    }
}

