/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.error.handler.email;

import com.google.common.base.Strings;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Date;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.shardingsphere.elasticjob.error.handler.JobErrorHandler;
import org.apache.shardingsphere.elasticjob.error.handler.email.EmailPropertiesConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EmailJobErrorHandler
implements JobErrorHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EmailJobErrorHandler.class);
    private Session session;
    private String subject;
    private String from;
    private String to;
    private String cc;
    private String bcc;

    public void init(Properties props) {
        String host = props.getProperty("email.host");
        int port = Integer.parseInt(props.getProperty("email.port"));
        boolean isUseSSL = Boolean.parseBoolean(props.getProperty("email.useSsl", EmailPropertiesConstants.DEFAULT_IS_USE_SSL));
        boolean isDebug = Boolean.parseBoolean(props.getProperty("email.debug", EmailPropertiesConstants.DEFAULT_IS_DEBUG));
        String username = props.getProperty("email.username");
        String password = props.getProperty("email.password");
        String sslTrust = props.getProperty("email.ssl.trust");
        this.session = Session.getDefaultInstance((Properties)this.createSessionProperties(host, port, isUseSSL, isDebug, sslTrust), (Authenticator)this.getSessionAuthenticator(username, password));
        this.subject = props.getProperty("email.subject", "ElasticJob error message");
        this.from = props.getProperty("email.from");
        this.to = props.getProperty("email.to");
        this.cc = props.getProperty("email.cc");
        this.bcc = props.getProperty("email.bcc");
    }

    private Properties createSessionProperties(String host, int port, boolean isUseSSL, boolean isDebug, String sslTrust) {
        Properties result = new Properties();
        result.put("mail.smtp.host", host);
        result.put("mail.smtp.port", (Object)port);
        result.put("mail.smtp.auth", Boolean.TRUE.toString());
        result.put("mail.transport.protocol", "smtp");
        result.setProperty("mail.debug", Boolean.toString(isDebug));
        if (isUseSSL) {
            result.setProperty("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
            result.setProperty("mail.smtp.socketFactory.fallback", Boolean.FALSE.toString());
            if (!Strings.isNullOrEmpty((String)sslTrust)) {
                result.setProperty("mail.smtp.ssl.trust", sslTrust);
            }
        }
        return result;
    }

    private Authenticator getSessionAuthenticator(final String username, final String password) {
        return new Authenticator(){

            public PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(username, password);
            }
        };
    }

    public void handleException(String jobName, Throwable cause) {
        String errorMessage = this.getErrorMessage(jobName, cause);
        try {
            this.sendMessage(this.createMessage(errorMessage));
            log.info("An exception has occurred in Job '{}', an email has been sent successfully.", (Object)jobName, (Object)cause);
        }
        catch (MessagingException ex) {
            cause.addSuppressed(ex);
            log.error("An exception has occurred in Job '{}' but failed to send email because of", (Object)jobName, (Object)cause);
        }
    }

    private String getErrorMessage(String jobName, Throwable cause) {
        StringWriter writer = new StringWriter();
        cause.printStackTrace(new PrintWriter((Writer)writer, true));
        return String.format("Job '%s' exception occur in job processing, caused by %s", jobName, writer);
    }

    private Message createMessage(String content) throws MessagingException {
        MimeMessage result = new MimeMessage(this.session);
        result.setFrom((Address)new InternetAddress(this.from));
        result.setSubject(this.subject);
        result.setSentDate(new Date());
        MimeMultipart multipart = new MimeMultipart();
        MimeBodyPart mailBody = new MimeBodyPart();
        mailBody.setContent((Object)content, "text/html; charset=utf-8");
        multipart.addBodyPart((BodyPart)mailBody);
        result.setContent((Multipart)multipart);
        if (StringUtils.isNotBlank((CharSequence)this.to)) {
            String[] tos;
            for (String each : tos = this.to.split(",")) {
                result.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(each));
            }
        }
        if (!Strings.isNullOrEmpty((String)this.cc)) {
            result.addRecipient(Message.RecipientType.CC, (Address)new InternetAddress(this.cc));
        }
        if (!Strings.isNullOrEmpty((String)this.bcc)) {
            result.addRecipient(Message.RecipientType.BCC, (Address)new InternetAddress(this.bcc));
        }
        result.saveChanges();
        return result;
    }

    private void sendMessage(Message message) throws MessagingException {
        try (Transport transport = this.session.getTransport();){
            transport.connect();
            transport.sendMessage(message, message.getAllRecipients());
        }
    }

    public String getType() {
        return "EMAIL";
    }
}

