/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.cloud.console.config.serializer;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.netty.handler.codec.http.HttpHeaderValues;
import java.nio.charset.StandardCharsets;
import org.apache.shardingsphere.elasticjob.restful.serializer.ResponseBodySerializer;

public final class JsonResponseBodySerializer
implements ResponseBodySerializer {
    private final Gson gson = new GsonBuilder().serializeNulls().create();

    public String mimeType() {
        return HttpHeaderValues.APPLICATION_JSON.toString();
    }

    public byte[] serialize(Object responseBody) {
        if (responseBody instanceof String) {
            return ((String)responseBody).getBytes(StandardCharsets.UTF_8);
        }
        return this.gson.toJson(responseBody).getBytes(StandardCharsets.UTF_8);
    }
}

