/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.cloud.scheduler.statistics;

import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.elasticjob.cloud.config.CloudJobExecutionType;
import org.apache.shardingsphere.elasticjob.cloud.config.pojo.CloudJobConfigurationPOJO;
import org.apache.shardingsphere.elasticjob.cloud.scheduler.config.job.CloudJobConfigurationService;
import org.apache.shardingsphere.elasticjob.cloud.scheduler.statistics.StatisticsScheduler;
import org.apache.shardingsphere.elasticjob.cloud.scheduler.statistics.TaskResultMetaData;
import org.apache.shardingsphere.elasticjob.cloud.scheduler.statistics.job.JobRunningStatisticJob;
import org.apache.shardingsphere.elasticjob.cloud.scheduler.statistics.job.RegisteredJobStatisticJob;
import org.apache.shardingsphere.elasticjob.cloud.scheduler.statistics.job.TaskResultStatisticJob;
import org.apache.shardingsphere.elasticjob.cloud.scheduler.statistics.util.StatisticTimeUtils;
import org.apache.shardingsphere.elasticjob.cloud.statistics.StatisticInterval;
import org.apache.shardingsphere.elasticjob.cloud.statistics.rdb.StatisticRdbRepository;
import org.apache.shardingsphere.elasticjob.cloud.statistics.type.job.JobExecutionTypeStatistics;
import org.apache.shardingsphere.elasticjob.cloud.statistics.type.job.JobRegisterStatistics;
import org.apache.shardingsphere.elasticjob.cloud.statistics.type.job.JobRunningStatistics;
import org.apache.shardingsphere.elasticjob.cloud.statistics.type.task.TaskResultStatistics;
import org.apache.shardingsphere.elasticjob.cloud.statistics.type.task.TaskRunningStatistics;
import org.apache.shardingsphere.elasticjob.reg.base.CoordinatorRegistryCenter;
import org.apache.shardingsphere.elasticjob.tracing.api.TracingConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StatisticManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StatisticManager.class);
    private static volatile StatisticManager instance;
    private final CoordinatorRegistryCenter registryCenter;
    private final CloudJobConfigurationService configurationService;
    private final TracingConfiguration tracingConfiguration;
    private final StatisticsScheduler scheduler;
    private final Map<StatisticInterval, TaskResultMetaData> statisticData;
    private StatisticRdbRepository rdbRepository;

    private StatisticManager(CoordinatorRegistryCenter registryCenter, TracingConfiguration tracingConfiguration, StatisticsScheduler scheduler, Map<StatisticInterval, TaskResultMetaData> statisticData) {
        this.registryCenter = registryCenter;
        this.configurationService = new CloudJobConfigurationService(registryCenter);
        this.tracingConfiguration = tracingConfiguration;
        this.scheduler = scheduler;
        this.statisticData = statisticData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static StatisticManager getInstance(CoordinatorRegistryCenter regCenter, TracingConfiguration tracingConfiguration) {
        if (null != instance) return instance;
        Class<StatisticManager> clazz = StatisticManager.class;
        synchronized (StatisticManager.class) {
            if (null != instance) return instance;
            HashMap<StatisticInterval, TaskResultMetaData> statisticData = new HashMap<StatisticInterval, TaskResultMetaData>();
            statisticData.put(StatisticInterval.MINUTE, new TaskResultMetaData());
            statisticData.put(StatisticInterval.HOUR, new TaskResultMetaData());
            statisticData.put(StatisticInterval.DAY, new TaskResultMetaData());
            instance = new StatisticManager(regCenter, tracingConfiguration, new StatisticsScheduler(), statisticData);
            StatisticManager.init();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return instance;
        }
    }

    private static void init() {
        if (null != StatisticManager.instance.tracingConfiguration) {
            try {
                StatisticManager.instance.rdbRepository = new StatisticRdbRepository((DataSource)StatisticManager.instance.tracingConfiguration.getTracingStorageConfiguration().getStorage());
            }
            catch (SQLException ex) {
                log.error("Init StatisticRdbRepository error:", (Throwable)ex);
            }
        }
    }

    public void startup() {
        if (null != this.rdbRepository) {
            this.scheduler.start();
            this.scheduler.register(new TaskResultStatisticJob(StatisticInterval.MINUTE, this.statisticData.get(StatisticInterval.MINUTE), this.rdbRepository));
            this.scheduler.register(new TaskResultStatisticJob(StatisticInterval.HOUR, this.statisticData.get(StatisticInterval.HOUR), this.rdbRepository));
            this.scheduler.register(new TaskResultStatisticJob(StatisticInterval.DAY, this.statisticData.get(StatisticInterval.DAY), this.rdbRepository));
            this.scheduler.register(new JobRunningStatisticJob(this.registryCenter, this.rdbRepository));
            this.scheduler.register(new RegisteredJobStatisticJob(this.configurationService, this.rdbRepository));
        }
    }

    public void shutdown() {
        this.scheduler.shutdown();
    }

    public void taskRunSuccessfully() {
        this.statisticData.get(StatisticInterval.MINUTE).incrementAndGetSuccessCount();
        this.statisticData.get(StatisticInterval.HOUR).incrementAndGetSuccessCount();
        this.statisticData.get(StatisticInterval.DAY).incrementAndGetSuccessCount();
    }

    public void taskRunFailed() {
        this.statisticData.get(StatisticInterval.MINUTE).incrementAndGetFailedCount();
        this.statisticData.get(StatisticInterval.HOUR).incrementAndGetFailedCount();
        this.statisticData.get(StatisticInterval.DAY).incrementAndGetFailedCount();
    }

    private boolean isRdbConfigured() {
        return null != this.rdbRepository;
    }

    public TaskResultStatistics getTaskResultStatisticsWeekly() {
        if (!this.isRdbConfigured()) {
            return new TaskResultStatistics(0, 0, StatisticInterval.DAY, new Date());
        }
        return this.rdbRepository.getSummedTaskResultStatistics(StatisticTimeUtils.getStatisticTime(StatisticInterval.DAY, -7), StatisticInterval.DAY);
    }

    public TaskResultStatistics getTaskResultStatisticsSinceOnline() {
        if (!this.isRdbConfigured()) {
            return new TaskResultStatistics(0, 0, StatisticInterval.DAY, new Date());
        }
        return this.rdbRepository.getSummedTaskResultStatistics(this.getOnlineDate(), StatisticInterval.DAY);
    }

    public TaskResultStatistics findLatestTaskResultStatistics(StatisticInterval statisticInterval) {
        Optional result;
        if (this.isRdbConfigured() && (result = this.rdbRepository.findLatestTaskResultStatistics(statisticInterval)).isPresent()) {
            return (TaskResultStatistics)result.get();
        }
        return new TaskResultStatistics(0, 0, statisticInterval, new Date());
    }

    public List<TaskResultStatistics> findTaskResultStatisticsDaily() {
        if (!this.isRdbConfigured()) {
            return Collections.emptyList();
        }
        return this.rdbRepository.findTaskResultStatistics(StatisticTimeUtils.getStatisticTime(StatisticInterval.HOUR, -24), StatisticInterval.MINUTE);
    }

    public JobExecutionTypeStatistics getJobExecutionTypeStatistics() {
        int transientJobCnt = 0;
        int daemonJobCnt = 0;
        for (CloudJobConfigurationPOJO each : this.configurationService.loadAll()) {
            if (CloudJobExecutionType.TRANSIENT.equals((Object)each.getJobExecutionType())) {
                ++transientJobCnt;
                continue;
            }
            if (!CloudJobExecutionType.DAEMON.equals((Object)each.getJobExecutionType())) continue;
            ++daemonJobCnt;
        }
        return new JobExecutionTypeStatistics(transientJobCnt, daemonJobCnt);
    }

    public List<TaskRunningStatistics> findTaskRunningStatisticsWeekly() {
        if (!this.isRdbConfigured()) {
            return Collections.emptyList();
        }
        return this.rdbRepository.findTaskRunningStatistics(StatisticTimeUtils.getStatisticTime(StatisticInterval.DAY, -7));
    }

    public List<JobRunningStatistics> findJobRunningStatisticsWeekly() {
        if (!this.isRdbConfigured()) {
            return Collections.emptyList();
        }
        return this.rdbRepository.findJobRunningStatistics(StatisticTimeUtils.getStatisticTime(StatisticInterval.DAY, -7));
    }

    public List<JobRegisterStatistics> findJobRegisterStatisticsSinceOnline() {
        if (!this.isRdbConfigured()) {
            return Collections.emptyList();
        }
        return this.rdbRepository.findJobRegisterStatistics(this.getOnlineDate());
    }

    private Date getOnlineDate() {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        try {
            return formatter.parse("2016-12-16");
        }
        catch (ParseException ex) {
            return null;
        }
    }

    @Generated
    private StatisticManager(CoordinatorRegistryCenter registryCenter, CloudJobConfigurationService configurationService, TracingConfiguration tracingConfiguration, StatisticsScheduler scheduler, Map<StatisticInterval, TaskResultMetaData> statisticData) {
        this.registryCenter = registryCenter;
        this.configurationService = configurationService;
        this.tracingConfiguration = tracingConfiguration;
        this.scheduler = scheduler;
        this.statisticData = statisticData;
    }
}

