/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.fenzo;

import com.netflix.fenzo.AutoScaleRule;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

class AutoScaleRules {
    private final Map<String, AutoScaleRule> ruleMap;
    private final BlockingQueue<AutoScaleRule> addQ = new LinkedBlockingQueue<AutoScaleRule>();
    private final List<AutoScaleRule> addList = new LinkedList<AutoScaleRule>();
    private final BlockingQueue<String> remQ = new LinkedBlockingQueue<String>();
    private final List<String> remList = new LinkedList<String>();

    AutoScaleRules(List<AutoScaleRule> autoScaleRules) {
        this.ruleMap = new HashMap<String, AutoScaleRule>();
        if (autoScaleRules != null && !autoScaleRules.isEmpty()) {
            for (AutoScaleRule r : autoScaleRules) {
                this.ruleMap.put(r.getRuleName(), r);
            }
        }
    }

    void replaceRule(AutoScaleRule rule) {
        if (rule != null) {
            this.addQ.offer(rule);
        }
    }

    void remRule(String ruleName) {
        if (ruleName != null) {
            this.remQ.offer(ruleName);
        }
    }

    void prepare() {
        Iterator<Object> iterator;
        this.addQ.drainTo(this.addList);
        if (!this.addList.isEmpty()) {
            iterator = this.addList.iterator();
            while (iterator.hasNext()) {
                AutoScaleRule r = iterator.next();
                if (r != null && r.getRuleName() != null) {
                    this.ruleMap.put(r.getRuleName(), r);
                }
                iterator.remove();
            }
        }
        this.remQ.drainTo(this.remList);
        if (!this.remList.isEmpty()) {
            iterator = this.remList.iterator();
            while (iterator.hasNext()) {
                String name = (String)iterator.next();
                if (name != null) {
                    this.ruleMap.remove(name);
                }
                iterator.remove();
            }
        }
    }

    public AutoScaleRule get(String attrValue) {
        return this.ruleMap.get(attrValue);
    }

    Collection<AutoScaleRule> getRules() {
        return this.ruleMap.values();
    }
}

