/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.fenzo;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.netflix.fenzo.AssignableVirtualMachine;
import com.netflix.fenzo.AssignmentFailure;
import com.netflix.fenzo.ConstraintFailure;
import com.netflix.fenzo.PreferentialNamedConsumableResourceSet;
import com.netflix.fenzo.TaskRequest;
import java.util.ArrayList;
import java.util.List;

public class TaskAssignmentResult {
    @JsonIgnore
    private final AssignableVirtualMachine avm;
    @JsonIgnore
    private final TaskRequest request;
    private final String taskId;
    private final String hostname;
    private final List<Integer> assignedPorts;
    private final List<PreferentialNamedConsumableResourceSet.ConsumeResult> rSets;
    private final boolean successful;
    private final List<AssignmentFailure> failures;
    private final ConstraintFailure constraintFailure;
    private final double fitness;

    @JsonCreator
    @JsonIgnoreProperties(ignoreUnknown=true)
    TaskAssignmentResult(@JsonProperty(value="avm") AssignableVirtualMachine avm, @JsonProperty(value="request") TaskRequest request, @JsonProperty(value="successful") boolean successful, @JsonProperty(value="failures") List<AssignmentFailure> failures, @JsonProperty(value="constraintFailure") ConstraintFailure constraintFailure, @JsonProperty(value="fitness") double fitness) {
        this.avm = avm;
        this.request = request;
        this.taskId = request.getId();
        this.hostname = avm == null ? "" : avm.getHostname();
        this.successful = successful;
        this.failures = failures;
        this.constraintFailure = constraintFailure;
        this.fitness = fitness;
        this.assignedPorts = new ArrayList<Integer>();
        this.rSets = new ArrayList<PreferentialNamedConsumableResourceSet.ConsumeResult>();
    }

    public String getTaskId() {
        return this.taskId;
    }

    public String getHostname() {
        return this.hostname;
    }

    void assignResult() {
        this.avm.assignResult(this);
    }

    void addPort(int port) {
        this.assignedPorts.add(port);
    }

    void addResourceSet(PreferentialNamedConsumableResourceSet.ConsumeResult rSet) {
        this.rSets.add(rSet);
    }

    public List<Integer> getAssignedPorts() {
        return this.assignedPorts;
    }

    public List<PreferentialNamedConsumableResourceSet.ConsumeResult> getrSets() {
        return this.rSets;
    }

    @JsonIgnore
    public TaskRequest getRequest() {
        return this.request;
    }

    public boolean isSuccessful() {
        return this.successful;
    }

    public List<AssignmentFailure> getFailures() {
        return this.failures;
    }

    public ConstraintFailure getConstraintFailure() {
        return this.constraintFailure;
    }

    public double getFitness() {
        return this.fitness;
    }

    public String toString() {
        return "TaskAssignmentResult{host=" + this.avm.getHostname() + ", request=" + this.request + ", taskId='" + this.taskId + '\'' + ", hostname='" + this.hostname + '\'' + ", assignedPorts=" + this.assignedPorts + ", successful=" + this.successful + ", failures=" + this.failures + ", constraintFailure=" + this.constraintFailure + ", fitness=" + this.fitness + '}';
    }
}

