/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.fenzo.plugins;

import com.netflix.fenzo.ScaleDownOrderEvaluator;
import com.netflix.fenzo.VirtualMachineLease;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;

public class InactiveClusterScaleDownConstraintEvaluator
implements ScaleDownOrderEvaluator {
    private final Function<VirtualMachineLease, Boolean> isInactive;

    public InactiveClusterScaleDownConstraintEvaluator(Function<VirtualMachineLease, Boolean> isInactive) {
        this.isInactive = isInactive;
    }

    @Override
    public List<Set<VirtualMachineLease>> evaluate(Collection<VirtualMachineLease> candidates) {
        HashSet active = new HashSet();
        HashSet inactive = new HashSet();
        candidates.forEach(l -> {
            if (this.isInactive((VirtualMachineLease)l)) {
                inactive.add(l);
            } else {
                active.add(l);
            }
        });
        inactive.addAll(active);
        return Arrays.asList(inactive, active);
    }

    private boolean isInactive(VirtualMachineLease lease) {
        try {
            Boolean inactive = this.isInactive.apply(lease);
            return inactive != null && inactive != false;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

