/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.restful.deserializer.impl;

import com.google.gson.Gson;
import io.netty.handler.codec.http.HttpHeaderValues;
import java.nio.charset.StandardCharsets;
import org.apache.shardingsphere.elasticjob.infra.json.GsonFactory;
import org.apache.shardingsphere.elasticjob.restful.deserializer.RequestBodyDeserializer;

public final class DefaultJsonRequestBodyDeserializer
implements RequestBodyDeserializer {
    private final Gson gson = GsonFactory.getGson();

    @Override
    public String mimeType() {
        return HttpHeaderValues.APPLICATION_JSON.toString();
    }

    @Override
    public <T> T deserialize(Class<T> targetType, byte[] requestBodyBytes) {
        if (0 == requestBodyBytes.length) {
            return null;
        }
        return (T)this.gson.fromJson(new String(requestBodyBytes, StandardCharsets.UTF_8), targetType);
    }
}

