/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.error.handler.wechat;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Properties;
import lombok.Generated;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.apache.shardingsphere.elasticjob.error.handler.JobErrorHandler;
import org.apache.shardingsphere.elasticjob.infra.json.GsonFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WechatJobErrorHandler
implements JobErrorHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WechatJobErrorHandler.class);
    private final CloseableHttpClient httpclient = HttpClients.createDefault();
    private String webhook;
    private int connectTimeoutMilliseconds;
    private int readTimeoutMilliseconds;

    public void init(Properties props) {
        this.webhook = props.getProperty("wechat.webhook");
        this.connectTimeoutMilliseconds = Integer.parseInt(props.getProperty("wechat.connectTimeoutMilliseconds", "3000"));
        this.readTimeoutMilliseconds = Integer.parseInt(props.getProperty("wechat.readTimeoutMilliseconds", "5000"));
    }

    public void handleException(String jobName, Throwable cause) {
        HttpPost httpPost = this.createHTTPPostMethod(jobName, cause);
        try (CloseableHttpResponse response = this.httpclient.execute((HttpUriRequest)httpPost);){
            int status = response.getStatusLine().getStatusCode();
            if (200 == status) {
                JsonObject resp = (JsonObject)GsonFactory.getGson().fromJson(EntityUtils.toString((HttpEntity)response.getEntity()), JsonObject.class);
                if (!"0".equals(resp.get("errcode").getAsString())) {
                    log.error("An exception has occurred in Job '{}' but failed to send wechat because of: {}", new Object[]{jobName, resp.get("errmsg").getAsString(), cause});
                } else {
                    log.info("An exception has occurred in Job '{}', an wechat message has been sent successful.", (Object)jobName, (Object)cause);
                }
            } else {
                log.error("An exception has occurred in Job '{}' but failed to send wechat because of: unexpected http response status: {}", new Object[]{jobName, status, cause});
            }
        }
        catch (IOException ex) {
            cause.addSuppressed(ex);
            log.error("An exception has occurred in Job '{}' but failed to send wechat because of", (Object)jobName, (Object)cause);
        }
    }

    private HttpPost createHTTPPostMethod(String jobName, Throwable cause) {
        HttpPost result = new HttpPost(this.webhook);
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(this.connectTimeoutMilliseconds).setSocketTimeout(this.readTimeoutMilliseconds).build();
        result.setConfig(requestConfig);
        StringEntity entity = new StringEntity(this.getJsonParameter(this.getErrorMessage(jobName, cause)), StandardCharsets.UTF_8);
        entity.setContentEncoding(StandardCharsets.UTF_8.name());
        entity.setContentType("application/json");
        result.setEntity((HttpEntity)entity);
        return result;
    }

    private String getJsonParameter(String message) {
        return GsonFactory.getGson().toJson((Object)ImmutableMap.of((Object)"msgtype", (Object)"text", (Object)"text", Collections.singletonMap("content", message)));
    }

    private String getErrorMessage(String jobName, Throwable cause) {
        StringWriter stringWriter = new StringWriter();
        cause.printStackTrace(new PrintWriter((Writer)stringWriter, true));
        return String.format("Job '%s' exception occur in job processing, caused by %s", jobName, stringWriter.toString());
    }

    public String getType() {
        return "WECHAT";
    }

    public void close() {
        this.httpclient.close();
    }
}

