/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mapping.model;

import org.springframework.data.mapping.IdentifierAccessor;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.util.Assert;

public class IdPropertyIdentifierAccessor
implements IdentifierAccessor {
    private final PersistentPropertyAccessor accessor;
    private final PersistentProperty<?> idProperty;

    public IdPropertyIdentifierAccessor(PersistentEntity<?, ?> entity, Object target) {
        Assert.notNull(entity, (String)"PersistentEntity must not be 'null'");
        Assert.isTrue((boolean)entity.hasIdProperty(), (String)"PersistentEntity does not have an identifier property!");
        this.idProperty = entity.getIdProperty();
        this.accessor = entity.getPropertyAccessor(target);
    }

    @Override
    public Object getIdentifier() {
        return this.accessor.getProperty(this.idProperty);
    }
}

