/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.criteria;

import java.util.Collection;
import javax.persistence.criteria.ParameterExpression;
import org.apache.openjpa.kernel.exps.ExpressionFactory;
import org.apache.openjpa.kernel.exps.Parameter;
import org.apache.openjpa.kernel.exps.Value;
import org.apache.openjpa.lib.util.OrderedMap;
import org.apache.openjpa.persistence.criteria.AliasContext;
import org.apache.openjpa.persistence.criteria.BindableParameter;
import org.apache.openjpa.persistence.criteria.CriteriaQueryImpl;
import org.apache.openjpa.persistence.criteria.ExpressionImpl;
import org.apache.openjpa.persistence.criteria.Expressions;
import org.apache.openjpa.util.InternalException;

class ParameterExpressionImpl<T>
extends ExpressionImpl<T>
implements ParameterExpression<T>,
BindableParameter {
    private String _name;
    private int _index = 0;
    private Object value;

    public ParameterExpressionImpl(Class<T> cls, String name) {
        super(cls);
        if (name != null) {
            this.assertValidName(name);
        }
        this._name = name;
    }

    public final String getName() {
        return this._name;
    }

    public final Integer getPosition() {
        throw new InternalException(this + " must not be asked for its position");
    }

    void setIndex(int index) {
        this._index = index;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("ParameterExpression");
        buf.append("<" + this.getJavaType().getSimpleName() + ">");
        if (this._name != null) {
            buf.append("('" + this._name + "')");
        }
        return buf.toString();
    }

    @Override
    public void setValue(Object value) {
        this.value = value;
    }

    @Override
    public Object value() {
        return this.value;
    }

    @Override
    public Value toValue(ExpressionFactory factory, CriteriaQueryImpl<?> q) {
        Class clzz = this.getJavaType();
        Object paramKey = this._name == null ? Integer.valueOf(this._index) : this._name;
        boolean isCollectionValued = Collection.class.isAssignableFrom(clzz);
        Parameter param = isCollectionValued ? factory.newCollectionValuedParameter(paramKey, clzz) : factory.newParameter(paramKey, clzz);
        int index = this._name != null ? this.findIndexWithSameName(q) : this._index;
        param.setIndex(index);
        return param;
    }

    private int findIndexWithSameName(CriteriaQueryImpl<?> q) {
        OrderedMap<Object, Class<?>> parameterTypes = q.getParameterTypes();
        int i = 0;
        for (Object k : parameterTypes.keySet()) {
            if (this.paramEquals(k)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public StringBuilder asValue(AliasContext q) {
        return Expressions.asValue(q, ":", this._name == null ? "param" : this._name);
    }

    public Class<T> getParameterType() {
        return this.getJavaType();
    }

    public boolean paramEquals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ParameterExpressionImpl that = (ParameterExpressionImpl)o;
        if (this._name != null ? !this._name.equals(that._name) : that._name != null) {
            return false;
        }
        if (this._name == null && this._index != that._index) {
            return false;
        }
        if (this.getParameterType() != ((ParameterExpressionImpl)o).getParameterType()) {
            return false;
        }
        return this.value != null ? this.value.equals(that.value) : that.value == null;
    }

    public boolean equals(Object o) {
        return this == o;
    }

    public int hashCode() {
        return super.hashCode();
    }
}

