/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.cloud.ui.security;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Strings;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shardingsphere.elasticjob.cloud.ui.security.AuthenticationResult;
import org.apache.shardingsphere.elasticjob.cloud.ui.security.UserAccount;
import org.apache.shardingsphere.elasticjob.cloud.ui.security.UserAuthenticationService;
import org.apache.shardingsphere.elasticjob.cloud.ui.web.response.ResponseResultUtil;

public final class AuthenticationFilter
implements Filter {
    private static final String LOGIN_URI = "/api/login";
    private final ObjectMapper objectMapper = new ObjectMapper();
    private UserAuthenticationService userAuthenticationService;

    public void init(FilterConfig filterConfig) {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)servletRequest;
        HttpServletResponse httpResponse = (HttpServletResponse)servletResponse;
        if (LOGIN_URI.equals(httpRequest.getRequestURI())) {
            this.handleLogin(httpRequest, httpResponse);
            return;
        }
        String accessToken = httpRequest.getHeader("Access-Token");
        if (Strings.isNullOrEmpty((String)accessToken) || !this.userAuthenticationService.isValidToken(accessToken)) {
            this.respondWithUnauthorized(httpResponse);
            return;
        }
        filterChain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
    }

    public void destroy() {
    }

    private void handleLogin(HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        try {
            UserAccount user = (UserAccount)this.objectMapper.readValue((Reader)httpRequest.getReader(), UserAccount.class);
            AuthenticationResult authenticationResult = this.userAuthenticationService.checkUser(user);
            if (!authenticationResult.isSuccess()) {
                this.respondWithUnauthorized(httpResponse);
                return;
            }
            httpResponse.setContentType("application/json");
            httpResponse.setCharacterEncoding("UTF-8");
            HashMap<String, String> result = new HashMap<String, String>(2, 1.0f);
            result.put("username", authenticationResult.getUsername());
            result.put("accessToken", this.userAuthenticationService.getToken(authenticationResult.getUsername()));
            this.objectMapper.writeValue((Writer)httpResponse.getWriter(), ResponseResultUtil.build(result));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void respondWithUnauthorized(HttpServletResponse httpResponse) throws IOException {
        httpResponse.setContentType("application/json");
        httpResponse.setCharacterEncoding("UTF-8");
        this.objectMapper.writeValue((Writer)httpResponse.getWriter(), (Object)ResponseResultUtil.handleUnauthorizedException("Unauthorized."));
    }

    public void setUserAuthenticationService(UserAuthenticationService userAuthenticationService) {
        this.userAuthenticationService = userAuthenticationService;
    }
}

