/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.cloud.ui.service.state.disable.app;

import org.apache.shardingsphere.elasticjob.cloud.ui.config.JobStateConfiguration;
import org.apache.shardingsphere.elasticjob.cloud.ui.service.state.disable.app.DisableAppNode;
import org.apache.shardingsphere.elasticjob.reg.base.CoordinatorRegistryCenter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DisableAppService {
    private static final Logger log = LoggerFactory.getLogger(DisableAppService.class);
    @Autowired
    private CoordinatorRegistryCenter regCenter;
    @Autowired
    private JobStateConfiguration jobStateConfiguration;

    public void add(String appName) {
        if (this.regCenter.getNumChildren("/state/disable/app") > this.jobStateConfiguration.getQueueSize()) {
            log.warn("Cannot add disable app, caused by read state queue size is larger than {}.", (Object)this.jobStateConfiguration.getQueueSize());
            return;
        }
        String disableAppNodePath = DisableAppNode.getDisableAppNodePath(appName);
        if (!this.regCenter.isExisted(disableAppNodePath)) {
            this.regCenter.persist(disableAppNodePath, appName);
        }
    }

    public void remove(String appName) {
        this.regCenter.remove(DisableAppNode.getDisableAppNodePath(appName));
    }

    public boolean isDisabled(String appName) {
        return this.regCenter.isExisted(DisableAppNode.getDisableAppNodePath(appName));
    }
}

