/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.http.executor;

import com.google.common.base.Strings;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Properties;
import lombok.Generated;
import org.apache.shardingsphere.elasticjob.api.ElasticJob;
import org.apache.shardingsphere.elasticjob.api.JobConfiguration;
import org.apache.shardingsphere.elasticjob.api.ShardingContext;
import org.apache.shardingsphere.elasticjob.executor.JobFacade;
import org.apache.shardingsphere.elasticjob.executor.item.impl.TypedJobItemExecutor;
import org.apache.shardingsphere.elasticjob.http.pojo.HttpParam;
import org.apache.shardingsphere.elasticjob.infra.exception.JobConfigurationException;
import org.apache.shardingsphere.elasticjob.infra.exception.JobExecutionException;
import org.apache.shardingsphere.elasticjob.infra.json.GsonFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HttpJobExecutor
implements TypedJobItemExecutor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HttpJobExecutor.class);

    public void process(ElasticJob elasticJob, JobConfiguration jobConfig, JobFacade jobFacade, ShardingContext shardingContext) {
        HttpParam httpParam = this.getHttpParam(jobConfig.getProps());
        HttpURLConnection connection = null;
        try {
            InputStream resultInputStream;
            int code;
            URL url = new URL(httpParam.getUrl());
            connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod(httpParam.getMethod());
            connection.setDoOutput(true);
            connection.setConnectTimeout(httpParam.getConnectTimeout());
            connection.setReadTimeout(httpParam.getReadTimeout());
            if (!Strings.isNullOrEmpty((String)httpParam.getContentType())) {
                connection.setRequestProperty("Content-Type", httpParam.getContentType());
            }
            connection.setRequestProperty("shardingContext", GsonFactory.getGson().toJson((Object)shardingContext));
            connection.connect();
            String data = httpParam.getData();
            if (this.isWriteMethod(httpParam.getMethod()) && !Strings.isNullOrEmpty((String)data)) {
                try (OutputStream outputStream = connection.getOutputStream();){
                    outputStream.write(data.getBytes(StandardCharsets.UTF_8));
                }
            }
            if (this.isRequestSucceed(code = connection.getResponseCode())) {
                resultInputStream = connection.getInputStream();
            } else {
                log.warn("HTTP job {} executed with response code {}", (Object)jobConfig.getJobName(), (Object)code);
                resultInputStream = connection.getErrorStream();
            }
            StringBuilder result = new StringBuilder();
            try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(resultInputStream, StandardCharsets.UTF_8));){
                String line;
                while (null != (line = bufferedReader.readLine())) {
                    result.append(line);
                }
            }
            if (this.isRequestSucceed(code)) {
                log.debug("HTTP job execute result : {}", (Object)result.toString());
            } else {
                log.warn("HTTP job {} executed with response body {}", (Object)jobConfig.getJobName(), (Object)result.toString());
            }
        }
        catch (IOException ex) {
            throw new JobExecutionException((Throwable)ex);
        }
        finally {
            if (null != connection) {
                connection.disconnect();
            }
        }
    }

    private HttpParam getHttpParam(Properties props) {
        String url = props.getProperty("http.uri");
        if (Strings.isNullOrEmpty((String)url)) {
            throw new JobConfigurationException("Cannot find HTTP URL, job is not executed.", new Object[0]);
        }
        String method = props.getProperty("http.method");
        if (Strings.isNullOrEmpty((String)method)) {
            throw new JobConfigurationException("Cannot find HTTP method, job is not executed.", new Object[0]);
        }
        String data = props.getProperty("http.data");
        int connectTimeout = Integer.parseInt(props.getProperty("http.connect.timeout.milliseconds", "3000"));
        int readTimeout = Integer.parseInt(props.getProperty("http.read.timeout.milliseconds", "5000"));
        String contentType = props.getProperty("http.content.type");
        return new HttpParam(url, method, data, connectTimeout, readTimeout, contentType);
    }

    private boolean isWriteMethod(String method) {
        return Arrays.asList("POST", "PUT", "DELETE").contains(method.toUpperCase());
    }

    private boolean isRequestSucceed(int httpStatusCode) {
        return 400 > httpStatusCode;
    }

    public String getType() {
        return "HTTP";
    }
}

