/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Date;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.h2.api.TimestampWithTimeZone;
import org.h2.message.DbException;
import org.h2.util.DateTimeUtils;
import org.h2.value.Value;
import org.h2.value.ValueDate;
import org.h2.value.ValueTime;
import org.h2.value.ValueTimestamp;
import org.h2.value.ValueTimestampTimeZone;

public class LocalDateTimeUtils {
    private static final Class<?> LOCAL_DATE = LocalDateTimeUtils.tryGetClass("java.time.LocalDate");
    private static final Class<?> LOCAL_TIME = LocalDateTimeUtils.tryGetClass("java.time.LocalTime");
    private static final Class<?> LOCAL_DATE_TIME = LocalDateTimeUtils.tryGetClass("java.time.LocalDateTime");
    private static final Class<?> OFFSET_DATE_TIME = LocalDateTimeUtils.tryGetClass("java.time.OffsetDateTime");
    private static final Class<?> ZONE_OFFSET = LocalDateTimeUtils.tryGetClass("java.time.ZoneOffset");
    private static final Method TO_LOCAL_DATE;
    private static final Method LOCAL_TIME_OF_NANO;
    private static final Method DATE_VALUE_OF;
    private static final Method LOCAL_TIME_TO_NANO;
    private static final Method LOCAL_DATE_OF_YEAR_MONTH_DAY;
    private static final Method LOCAL_DATE_PARSE;
    private static final Method LOCAL_DATE_GET_YEAR;
    private static final Method LOCAL_DATE_GET_MONTH_VALUE;
    private static final Method LOCAL_DATE_GET_DAY_OF_MONTH;
    private static final Method LOCAL_DATE_AT_START_OF_DAY;
    private static final Method LOCAL_TIME_PARSE;
    private static final Method LOCAL_DATE_TIME_PLUS_NANOS;
    private static final Method LOCAL_DATE_TIME_TO_LOCAL_DATE;
    private static final Method LOCAL_DATE_TIME_TRUNCATED_TO;
    private static final Method LOCAL_DATE_TIME_PARSE;
    private static final Method ZONE_OFFSET_OF_TOTAL_SECONDS;
    private static final Method OFFSET_DATE_TIME_OF_LOCAL_DATE_TIME_ZONE_OFFSET;
    private static final Method OFFSET_DATE_TIME_PARSE;
    private static final Method OFFSET_DATE_TIME_TO_LOCAL_DATE_TIME;
    private static final Method OFFSET_DATE_TIME_GET_OFFSET;
    private static final Method ZONE_OFFSET_GET_TOTAL_SECONDS;
    private static final Method DURATION_BETWEEN;
    private static final Method DURATION_TO_NANOS;
    private static final Object CHRONO_UNIT_DAYS;
    private static final boolean IS_JAVA8_DATE_API_PRESENT;

    private LocalDateTimeUtils() {
    }

    public static boolean isJava8DateApiPresent() {
        return IS_JAVA8_DATE_API_PRESENT;
    }

    public static Class<?> getLocalDateClass() {
        return LOCAL_DATE;
    }

    public static Class<?> getLocalTimeClass() {
        return LOCAL_TIME;
    }

    public static Class<?> getLocalDateTimeClass() {
        return LOCAL_DATE_TIME;
    }

    public static Class<?> getOffsetDateTimeClass() {
        return OFFSET_DATE_TIME;
    }

    public static Object parseLocalDate(CharSequence charSequence) {
        try {
            return LOCAL_DATE_PARSE.invoke(null, charSequence);
        }
        catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
            throw new IllegalArgumentException("error when parsing text '" + charSequence + "'", reflectiveOperationException);
        }
    }

    public static Object parseLocalTime(CharSequence charSequence) {
        try {
            return LOCAL_TIME_PARSE.invoke(null, charSequence);
        }
        catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
            throw new IllegalArgumentException("error when parsing text '" + charSequence + "'", reflectiveOperationException);
        }
    }

    public static Object parseLocalDateTime(CharSequence charSequence) {
        try {
            return LOCAL_DATE_TIME_PARSE.invoke(null, charSequence);
        }
        catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
            throw new IllegalArgumentException("error when parsing text '" + charSequence + "'", reflectiveOperationException);
        }
    }

    public static Object parseOffsetDateTime(CharSequence charSequence) {
        try {
            return OFFSET_DATE_TIME_PARSE.invoke(null, charSequence);
        }
        catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
            throw new IllegalArgumentException("error when parsing text '" + charSequence + "'", reflectiveOperationException);
        }
    }

    private static Class<?> tryGetClass(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class<?> getClass(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalStateException("Java 8 or later but class " + string + " is missing", classNotFoundException);
        }
    }

    private static Method getMethod(Class<?> clazz, String string, Class<?> ... classArray) {
        try {
            return clazz.getMethod(string, classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalStateException("Java 8 or later but method " + clazz.getName() + "#" + string + "(" + Arrays.toString(classArray) + ") is missing", noSuchMethodException);
        }
    }

    private static Object getFieldValue(Class<?> clazz, String string) {
        try {
            return clazz.getField(string).get(null);
        }
        catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
            throw new IllegalStateException("Java 8 or later but field " + clazz.getName() + "#" + string + " is missing", reflectiveOperationException);
        }
    }

    public static boolean isLocalDate(Class<?> clazz) {
        return LOCAL_DATE == clazz;
    }

    public static boolean isLocalTime(Class<?> clazz) {
        return LOCAL_TIME == clazz;
    }

    public static boolean isLocalDateTime(Class<?> clazz) {
        return LOCAL_DATE_TIME == clazz;
    }

    public static boolean isOffsetDateTime(Class<?> clazz) {
        return OFFSET_DATE_TIME == clazz;
    }

    public static Object valueToLocalDate(Value value) {
        return LocalDateTimeUtils.dateToLocalDate(value.getDate());
    }

    public static Object valueToLocalTime(Value value) {
        try {
            return LOCAL_TIME_OF_NANO.invoke(null, ((ValueTime)value.convertTo(9)).getNanos());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw DbException.convert(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw DbException.convertInvocation(invocationTargetException, "time conversion failed");
        }
    }

    private static Object dateToLocalDate(Date date) {
        try {
            return TO_LOCAL_DATE.invoke((Object)date, new Object[0]);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw DbException.convert(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw DbException.convertInvocation(invocationTargetException, "date conversion failed");
        }
    }

    public static Object valueToLocalDateTime(ValueTimestamp valueTimestamp) {
        long l = valueTimestamp.getDateValue();
        long l2 = valueTimestamp.getTimeNanos();
        try {
            Object object = LocalDateTimeUtils.localDateFromDateValue(l);
            Object object2 = LOCAL_DATE_AT_START_OF_DAY.invoke(object, new Object[0]);
            return LOCAL_DATE_TIME_PLUS_NANOS.invoke(object2, l2);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw DbException.convert(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw DbException.convertInvocation(invocationTargetException, "timestamp conversion failed");
        }
    }

    public static Object valueToOffsetDateTime(ValueTimestampTimeZone valueTimestampTimeZone) {
        return LocalDateTimeUtils.timestampWithTimeZoneToOffsetDateTime((TimestampWithTimeZone)valueTimestampTimeZone.getObject());
    }

    private static Object timestampWithTimeZoneToOffsetDateTime(TimestampWithTimeZone timestampWithTimeZone) {
        long l = timestampWithTimeZone.getYMD();
        long l2 = timestampWithTimeZone.getNanosSinceMidnight();
        try {
            Object object = LocalDateTimeUtils.localDateTimeFromDateNanos(l, l2);
            short s = timestampWithTimeZone.getTimeZoneOffsetMins();
            int n = (int)TimeUnit.MINUTES.toSeconds(s);
            Object object2 = ZONE_OFFSET_OF_TOTAL_SECONDS.invoke(null, n);
            return OFFSET_DATE_TIME_OF_LOCAL_DATE_TIME_ZONE_OFFSET.invoke(null, object, object2);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw DbException.convert(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw DbException.convertInvocation(invocationTargetException, "timestamp with time zone conversion failed");
        }
    }

    public static Value localDateToDateValue(Object object) {
        try {
            Date date = (Date)DATE_VALUE_OF.invoke(null, object);
            return ValueDate.get(date);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw DbException.convert(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw DbException.convertInvocation(invocationTargetException, "date conversion failed");
        }
    }

    public static Value localTimeToTimeValue(Object object) {
        try {
            return ValueTime.fromNanos((Long)LOCAL_TIME_TO_NANO.invoke(object, new Object[0]));
        }
        catch (IllegalAccessException illegalAccessException) {
            throw DbException.convert(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw DbException.convertInvocation(invocationTargetException, "time conversion failed");
        }
    }

    public static Value localDateTimeToValue(Object object) {
        try {
            Object object2 = LOCAL_DATE_TIME_TO_LOCAL_DATE.invoke(object, new Object[0]);
            long l = LocalDateTimeUtils.dateValueFromLocalDate(object2);
            long l2 = LocalDateTimeUtils.timeNanosFromLocalDate(object);
            return ValueTimestamp.fromDateValueAndNanos(l, l2);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw DbException.convert(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw DbException.convertInvocation(invocationTargetException, "local date time conversion failed");
        }
    }

    public static Value offsetDateTimeToValue(Object object) {
        try {
            Object object2 = OFFSET_DATE_TIME_TO_LOCAL_DATE_TIME.invoke(object, new Object[0]);
            Object object3 = LOCAL_DATE_TIME_TO_LOCAL_DATE.invoke(object2, new Object[0]);
            Object object4 = OFFSET_DATE_TIME_GET_OFFSET.invoke(object, new Object[0]);
            long l = LocalDateTimeUtils.dateValueFromLocalDate(object3);
            long l2 = LocalDateTimeUtils.timeNanosFromLocalDate(object2);
            short s = LocalDateTimeUtils.zoneOffsetToOffsetMinute(object4);
            return ValueTimestampTimeZone.fromDateValueAndNanos(l, l2, s);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw DbException.convert(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw DbException.convertInvocation(invocationTargetException, "time conversion failed");
        }
    }

    private static long dateValueFromLocalDate(Object object) throws IllegalAccessException, InvocationTargetException {
        int n = (Integer)LOCAL_DATE_GET_YEAR.invoke(object, new Object[0]);
        int n2 = (Integer)LOCAL_DATE_GET_MONTH_VALUE.invoke(object, new Object[0]);
        int n3 = (Integer)LOCAL_DATE_GET_DAY_OF_MONTH.invoke(object, new Object[0]);
        return DateTimeUtils.dateValue(n, n2, n3);
    }

    private static long timeNanosFromLocalDate(Object object) throws IllegalAccessException, InvocationTargetException {
        Object object2 = LOCAL_DATE_TIME_TRUNCATED_TO.invoke(object, CHRONO_UNIT_DAYS);
        Object object3 = DURATION_BETWEEN.invoke(null, object2, object);
        return (Long)DURATION_TO_NANOS.invoke(object3, new Object[0]);
    }

    private static short zoneOffsetToOffsetMinute(Object object) throws IllegalAccessException, InvocationTargetException {
        int n = (Integer)ZONE_OFFSET_GET_TOTAL_SECONDS.invoke(object, new Object[0]);
        return (short)TimeUnit.SECONDS.toMinutes(n);
    }

    private static Object localDateFromDateValue(long l) throws IllegalAccessException, InvocationTargetException {
        int n = DateTimeUtils.yearFromDateValue(l);
        int n2 = DateTimeUtils.monthFromDateValue(l);
        int n3 = DateTimeUtils.dayFromDateValue(l);
        return LOCAL_DATE_OF_YEAR_MONTH_DAY.invoke(null, n, n2, n3);
    }

    private static Object localDateTimeFromDateNanos(long l, long l2) throws IllegalAccessException, InvocationTargetException {
        Object object = LocalDateTimeUtils.localDateFromDateValue(l);
        Object object2 = LOCAL_DATE_AT_START_OF_DAY.invoke(object, new Object[0]);
        return LOCAL_DATE_TIME_PLUS_NANOS.invoke(object2, l2);
    }

    static {
        boolean bl = IS_JAVA8_DATE_API_PRESENT = LOCAL_DATE != null && LOCAL_TIME != null && LOCAL_DATE_TIME != null && OFFSET_DATE_TIME != null && ZONE_OFFSET != null;
        if (IS_JAVA8_DATE_API_PRESENT) {
            Class<?> clazz = LocalDateTimeUtils.getClass("java.time.temporal.TemporalUnit");
            Class<?> clazz2 = LocalDateTimeUtils.getClass("java.time.temporal.ChronoUnit");
            Class<?> clazz3 = LocalDateTimeUtils.getClass("java.time.Duration");
            Class<?> clazz4 = LocalDateTimeUtils.getClass("java.time.temporal.Temporal");
            TO_LOCAL_DATE = LocalDateTimeUtils.getMethod(Date.class, "toLocalDate", new Class[0]);
            LOCAL_TIME_OF_NANO = LocalDateTimeUtils.getMethod(LOCAL_TIME, "ofNanoOfDay", Long.TYPE);
            DATE_VALUE_OF = LocalDateTimeUtils.getMethod(Date.class, "valueOf", LOCAL_DATE);
            LOCAL_TIME_TO_NANO = LocalDateTimeUtils.getMethod(LOCAL_TIME, "toNanoOfDay", new Class[0]);
            LOCAL_DATE_OF_YEAR_MONTH_DAY = LocalDateTimeUtils.getMethod(LOCAL_DATE, "of", Integer.TYPE, Integer.TYPE, Integer.TYPE);
            LOCAL_DATE_PARSE = LocalDateTimeUtils.getMethod(LOCAL_DATE, "parse", CharSequence.class);
            LOCAL_DATE_GET_YEAR = LocalDateTimeUtils.getMethod(LOCAL_DATE, "getYear", new Class[0]);
            LOCAL_DATE_GET_MONTH_VALUE = LocalDateTimeUtils.getMethod(LOCAL_DATE, "getMonthValue", new Class[0]);
            LOCAL_DATE_GET_DAY_OF_MONTH = LocalDateTimeUtils.getMethod(LOCAL_DATE, "getDayOfMonth", new Class[0]);
            LOCAL_DATE_AT_START_OF_DAY = LocalDateTimeUtils.getMethod(LOCAL_DATE, "atStartOfDay", new Class[0]);
            LOCAL_TIME_PARSE = LocalDateTimeUtils.getMethod(LOCAL_TIME, "parse", CharSequence.class);
            LOCAL_DATE_TIME_PLUS_NANOS = LocalDateTimeUtils.getMethod(LOCAL_DATE_TIME, "plusNanos", Long.TYPE);
            LOCAL_DATE_TIME_TO_LOCAL_DATE = LocalDateTimeUtils.getMethod(LOCAL_DATE_TIME, "toLocalDate", new Class[0]);
            LOCAL_DATE_TIME_TRUNCATED_TO = LocalDateTimeUtils.getMethod(LOCAL_DATE_TIME, "truncatedTo", clazz);
            LOCAL_DATE_TIME_PARSE = LocalDateTimeUtils.getMethod(LOCAL_DATE_TIME, "parse", CharSequence.class);
            ZONE_OFFSET_OF_TOTAL_SECONDS = LocalDateTimeUtils.getMethod(ZONE_OFFSET, "ofTotalSeconds", Integer.TYPE);
            OFFSET_DATE_TIME_TO_LOCAL_DATE_TIME = LocalDateTimeUtils.getMethod(OFFSET_DATE_TIME, "toLocalDateTime", new Class[0]);
            OFFSET_DATE_TIME_GET_OFFSET = LocalDateTimeUtils.getMethod(OFFSET_DATE_TIME, "getOffset", new Class[0]);
            OFFSET_DATE_TIME_OF_LOCAL_DATE_TIME_ZONE_OFFSET = LocalDateTimeUtils.getMethod(OFFSET_DATE_TIME, "of", LOCAL_DATE_TIME, ZONE_OFFSET);
            OFFSET_DATE_TIME_PARSE = LocalDateTimeUtils.getMethod(OFFSET_DATE_TIME, "parse", CharSequence.class);
            ZONE_OFFSET_GET_TOTAL_SECONDS = LocalDateTimeUtils.getMethod(ZONE_OFFSET, "getTotalSeconds", new Class[0]);
            DURATION_BETWEEN = LocalDateTimeUtils.getMethod(clazz3, "between", clazz4, clazz4);
            DURATION_TO_NANOS = LocalDateTimeUtils.getMethod(clazz3, "toNanos", new Class[0]);
            CHRONO_UNIT_DAYS = LocalDateTimeUtils.getFieldValue(clazz2, "DAYS");
        } else {
            TO_LOCAL_DATE = null;
            LOCAL_TIME_OF_NANO = null;
            DATE_VALUE_OF = null;
            LOCAL_TIME_TO_NANO = null;
            LOCAL_DATE_OF_YEAR_MONTH_DAY = null;
            LOCAL_DATE_PARSE = null;
            LOCAL_DATE_GET_YEAR = null;
            LOCAL_DATE_GET_MONTH_VALUE = null;
            LOCAL_DATE_GET_DAY_OF_MONTH = null;
            LOCAL_DATE_AT_START_OF_DAY = null;
            LOCAL_TIME_PARSE = null;
            LOCAL_DATE_TIME_PLUS_NANOS = null;
            LOCAL_DATE_TIME_TO_LOCAL_DATE = null;
            LOCAL_DATE_TIME_TRUNCATED_TO = null;
            LOCAL_DATE_TIME_PARSE = null;
            ZONE_OFFSET_OF_TOTAL_SECONDS = null;
            OFFSET_DATE_TIME_TO_LOCAL_DATE_TIME = null;
            OFFSET_DATE_TIME_GET_OFFSET = null;
            OFFSET_DATE_TIME_OF_LOCAL_DATE_TIME_ZONE_OFFSET = null;
            OFFSET_DATE_TIME_PARSE = null;
            ZONE_OFFSET_GET_TOTAL_SECONDS = null;
            DURATION_BETWEEN = null;
            DURATION_TO_NANOS = null;
            CHRONO_UNIT_DAYS = null;
        }
    }
}

