/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.lite.ui.web.handler;

import java.util.Optional;
import org.apache.shardingsphere.elasticjob.lite.ui.exception.DriverClassNotInWhitelistException;
import org.apache.shardingsphere.elasticjob.lite.ui.exception.JdbcDriverNotFoundException;
import org.apache.shardingsphere.elasticjob.lite.ui.web.response.ResponseResult;
import org.apache.shardingsphere.elasticjob.lite.ui.web.response.ResponseResultUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
public final class RestExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(RestExceptionHandler.class);

    @ExceptionHandler(value={JdbcDriverNotFoundException.class})
    public ResponseResult<?> handleJdbcDriverNotFoundException(JdbcDriverNotFoundException ex) {
        log.error(ex.getLocalizedMessage(), (Throwable)ex);
        return ResponseResultUtil.handleUncaughtException(ex.getLocalizedMessage());
    }

    @ExceptionHandler(value={DriverClassNotInWhitelistException.class})
    public ResponseResult<?> handleDriverClassNotInWhitelistException(DriverClassNotInWhitelistException ex) {
        log.warn(ex.getMessage(), (Throwable)ex);
        return ResponseResultUtil.handleIllegalArgumentException(ex.getMessage());
    }

    @ExceptionHandler(value={Exception.class})
    public ResponseResult<?> handleException(Exception ex) {
        Throwable cause = Optional.ofNullable(ex.getCause()).orElse(ex);
        log.error(cause.getLocalizedMessage(), cause);
        return ResponseResultUtil.handleUncaughtException(cause.getLocalizedMessage());
    }
}

