/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.apache.bcel.classfile;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.aspectj.apache.bcel.classfile.Attribute;
import org.aspectj.apache.bcel.classfile.ClassVisitor;
import org.aspectj.apache.bcel.classfile.ConstantPool;
import org.aspectj.apache.bcel.classfile.ConstantUtf8;
import org.aspectj.apache.bcel.classfile.Utility;

public final class Unknown
extends Attribute {
    private byte[] bytes;
    private String name;

    public Unknown(Unknown unknown) {
        this(unknown.getNameIndex(), unknown.getLength(), unknown.getBytes(), unknown.getConstantPool());
    }

    public Unknown(int n, int n2, byte[] byArray, ConstantPool constantPool) {
        super((byte)-1, n, n2, constantPool);
        this.bytes = byArray;
        this.name = ((ConstantUtf8)constantPool.getConstant(n, (byte)1)).getValue();
    }

    Unknown(int n, int n2, DataInputStream dataInputStream, ConstantPool constantPool) throws IOException {
        this(n, n2, (byte[])null, constantPool);
        if (n2 > 0) {
            this.bytes = new byte[n2];
            dataInputStream.readFully(this.bytes);
        }
    }

    @Override
    public void accept(ClassVisitor classVisitor) {
        classVisitor.visitUnknown(this);
    }

    @Override
    public final void dump(DataOutputStream dataOutputStream) throws IOException {
        super.dump(dataOutputStream);
        if (this.length > 0) {
            dataOutputStream.write(this.bytes, 0, this.length);
        }
    }

    public final byte[] getBytes() {
        return this.bytes;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public final void setBytes(byte[] byArray) {
        this.bytes = byArray;
    }

    @Override
    public final String toString() {
        String string;
        if (this.length == 0 || this.bytes == null) {
            return "(Unknown attribute " + this.name + ")";
        }
        if (this.length > 10) {
            byte[] byArray = new byte[10];
            System.arraycopy(this.bytes, 0, byArray, 0, 10);
            string = Utility.toHexString(byArray) + "... (truncated)";
        } else {
            string = Utility.toHexString(this.bytes);
        }
        return "(Unknown attribute " + this.name + ": " + string + ")";
    }
}

